<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\CustomModels\ViisonPickwareERP\Supplier;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Shopware\Components\Model\ModelEntity;
use Shopware\Models\Shop\Currency;
use Symfony\Component\Validator\Constraints as Assert;
use Shopware\Models\Shop\Shop;

/**
 * @ORM\Entity
 * @ORM\Table(name="pickware_erp_suppliers")
 */
class Supplier extends ModelEntity
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="salutation", type="string", nullable=true)
     */
    private $salutation;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", nullable=false)
     */
    private $name;

    /**
     * @var string
     *
     * @ORM\Column(name="contact", type="string", nullable=false)
     */
    private $contact = '';

    /**
     * @var string
     *
     * @ORM\Column(name="address", type="text", nullable=true)
     */
    private $address;

    /**
     * @var string
     *
     * @Assert\Email
     * @Assert\NotBlank
     * @ORM\Column(name="email", type="string", nullable=false)
     */
    private $email = '';

    /**
     * @var string
     *
     * @ORM\Column(name="phone", type="string", length=40, nullable=false)
     */
    private $phone = '';

    /**
     * @var string
     *
     * @ORM\Column(name="fax", type="string", length=40, nullable=false)
     */
    private $fax = '';

    /**
     * @var string
     *
     * @ORM\Column(name="comment", type="text", nullable=true)
     */
    private $comment;

    /**
     * @var string
     *
     * @ORM\Column(name="customerNumber", type="string", length=40, nullable=true)
     */
    private $customerNumber;

    /**
     * @var int
     *
     * @ORM\Column(name="deliveryTime", type="integer", nullable=true)
     */
    private $deliveryTime;

    /**
     * @var int
     *
     * @ORM\Column(name="documentLocalizationSubShopId", type="integer", nullable=true)
     */
    private $documentLocalizationSubShopId;

    /**
     * @var int
     *
     * @ORM\Column(name="currencyId", type="integer", nullable=false)
     */
    private $currencyId;

    /**
     * @var string|null
     *
     * @ORM\Column(name="number", type="string", length=255, nullable=true)
     */
    private $number;

    /**
     * OWNING SIDE
     *
     * @var Shop
     *
     * @ORM\ManyToOne(targetEntity="Shopware\Models\Shop\Shop")
     * @ORM\JoinColumn(name="documentLocalizationSubShopId", referencedColumnName="id")
     */
    private $documentLocalizationSubShop;

    /**
     * OWNING SIDE
     *
     * @var Currency
     *
     * @ORM\ManyToOne(targetEntity="Shopware\Models\Shop\Currency")
     * @ORM\JoinColumn(name="currencyId", referencedColumnName="id")
     */
    private $currency;

    /**
     * INVERSE SIDE
     *
     * @var ArrayCollection
     *
     * @ORM\OneToMany(targetEntity="Shopware\CustomModels\ViisonPickwareERP\Supplier\ArticleDetailSupplierMapping", mappedBy="supplier", cascade={"remove"})
     */
    private $articleDetailSupplierMappings;

    /**
     * INVERSE SIDE
     *
     * @var ArrayCollection
     *
     * @ORM\OneToMany(targetEntity="Shopware\CustomModels\ViisonPickwareERP\Supplier\ManufacturerSupplierMapping", mappedBy="supplier", cascade={"remove"})
     */
    private $manufacturerSupplierMappings;

    /**
     * INVERSE SIDE
     *
     * @var ArrayCollection
     *
     * @ORM\OneToMany(targetEntity="Shopware\CustomModels\ViisonPickwareERP\SupplierOrder\SupplierOrder", mappedBy="supplier")
     */
    private $supplierOrders;

    /**
     * Creates a new Supplier instance.
     */
    public function __construct()
    {
        $this->articleDetailSupplierMappings = new ArrayCollection();
        $this->manufacturerSupplierMappings = new ArrayCollection();
        $this->supplierOrders = new ArrayCollection();
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getSalutation()
    {
        return $this->salutation;
    }

    /**
     * @param string $salutation
     */
    public function setSalutation($salutation)
    {
        $this->salutation = $salutation;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getContact()
    {
        return $this->contact;
    }

    /**
     * @param string $contact
     */
    public function setContact($contact)
    {
        $this->contact = $contact;
    }

    /**
     * @return string
     */
    public function getAddress()
    {
        return $this->address;
    }

    /**
     * @param string $address
     */
    public function setAddress($address)
    {
        $this->address = $address;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     */
    public function setEmail($email)
    {
        $this->email = $email;
    }

    /**
     * @return string
     */
    public function getPhone()
    {
        return $this->phone;
    }

    /**
     * @param string $phone
     */
    public function setPhone($phone)
    {
        $this->phone = $phone;
    }

    /**
     * @return string
     */
    public function getFax()
    {
        return $this->fax;
    }

    /**
     * @param string $fax
     */
    public function setFax($fax)
    {
        $this->fax = $fax;
    }

    /**
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }

    /**
     * @param string $comment
     */
    public function setComment($comment)
    {
        $this->comment = $comment;
    }

    /**
     * @return string
     */
    public function getCustomerNumber()
    {
        return $this->customerNumber;
    }

    /**
     * @param string $customerNumber
     */
    public function setCustomerNumber($customerNumber)
    {
        $this->customerNumber = $customerNumber;
    }

    /**
     * @return int
     */
    public function getDeliveryTime()
    {
        return $this->deliveryTime;
    }

    /**
     * @param int $deliveryTime
     */
    public function setDeliveryTime($deliveryTime)
    {
        $this->deliveryTime = $deliveryTime;
    }

    /**
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }

    /**
     * @param string|null $number
     */
    public function setNumber($number)
    {
        $this->number = $number;
    }

    /**
     * @return Shop
     */
    public function getDocumentLocalizationSubShop()
    {
        return $this->documentLocalizationSubShop;
    }

    /**
     * @param Shop|null $documentLocalizationSubShop
     */
    public function setDocumentLocalizationSubShop(Shop $documentLocalizationSubShop = null)
    {
        $this->documentLocalizationSubShop = $documentLocalizationSubShop;
    }

    /**
     * @return ArrayCollection
     */
    public function getArticleDetailSupplierMappings()
    {
        return $this->articleDetailSupplierMappings;
    }

    /**
     * @return ArrayCollection
     */
    public function getManufacturerSupplierMappings()
    {
        return $this->manufacturerSupplierMappings;
    }

    /**
     * @return ArrayCollection
     */
    public function getSupplierOrders()
    {
        return $this->supplierOrders;
    }

    /**
     * @return Currency
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @param Currency $currency
     */
    public function setCurrency($currency)
    {
        $this->currency = $currency;
    }

    /**
     * @return int
     */
    public function getCurrencyId()
    {
        return $this->currencyId;
    }

    /**
     * @param int $currencyId
     */
    public function setCurrencyId($currencyId)
    {
        $this->currencyId = $currencyId;
    }
}
