<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\CustomModels\ViisonPickwareERP\SupplierOrder;

use DateTime;
use Doctrine\ORM\Mapping as ORM;
use Shopware\Components\Model\ModelEntity;
use Shopware\Models\Media\Media;

/**
 * @ORM\Entity
 * @ORM\Table(name="pickware_erp_supplier_order_attachments")
 */
class SupplierOrderAttachment extends ModelEntity
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\Column(name="supplierOrderId", type="integer", nullable=false)
     */
    private $supplierOrderId;

    /**
     * @var string
     *
     * @ORM\Column(name="filename", type="string", length=255)
     */
    private $filename;

    /**
     * @var DateTime
     *
     * @ORM\Column(name="date", type="datetime", nullable=false)
     */
    private $date;

    /**
     * @var int
     *
     * @ORM\Column(name="mediaId", type="integer", nullable=false)
     */
    private $mediaId;

    /**
     * OWNING SIDE
     *
     * @var SupplierOrder
     *
     * @ORM\ManyToOne(targetEntity="Shopware\CustomModels\ViisonPickwareERP\SupplierOrder\SupplierOrder", inversedBy="attachments")
     * @ORM\JoinColumn(name="supplierOrderId", referencedColumnName="id")
     */
    private $supplierOrder;

    /**
     * OWNING SIDE
     *
     * @var Media
     *
     * @ORM\ManyToOne(targetEntity="Shopware\Models\Media\Media")
     * @ORM\JoinColumn(name="mediaId", referencedColumnName="id")
     */
    private $media;

    /**
     * @param SupplierOrder $supplierOrder
     * @param Media $media
     */
    public function __construct(SupplierOrder $supplierOrder, Media $media)
    {
        $this->supplierOrder = $supplierOrder;
        $this->media = $media;
        $this->supplierOrder->getAttachments()->add($this);
        $this->filename = $this->media->getFileName();
        $this->date = new DateTime();
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getFilename()
    {
        return $this->filename;
    }

    /**
     * @param string $filename
     */
    public function setFilename($filename)
    {
        $this->filename = $filename;
    }

    /**
     * @return DateTime
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @param DateTime|string $date
     */
    public function setDate($date)
    {
        $this->date = (is_string($date)) ? new DateTime($date) : $date;
    }

    /**
     * @return SupplierOrder
     */
    public function getSupplierOrder()
    {
        return $this->supplierOrder;
    }

    /**
     * @return Media
     */
    public function getMedia()
    {
        return $this->media;
    }
}
