<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\CustomModels\ViisonPickwareERP\SupplierOrder;

use Doctrine\ORM\Mapping as ORM;
use Shopware\Components\Model\ModelEntity;

/**
 * @ORM\Entity
 * @ORM\Table(name="pickware_erp_supplier_order_item_statuses")
 */
class SupplierOrderItemStatus extends ModelEntity
{
    const OPEN = 'open';
    const VALUE_OPEN = 0;
    const PARTLY_RECEIVED = 'partlyReceived';
    const VALUE_PARTLY_RECEIVED = 3;
    const COMPLETELY_RECEIVED = 'completelyReceived';
    const VALUE_COMPLETELY_RECEIVED = 4;
    const CANCELED = 'canceled';
    const VALUE_CANCELED = 5;
    const REFUND = 'refund';
    const VALUE_REFUND = 6;
    const MISSING = 'missing';
    const VALUE_MISSING = 7;

    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255, nullable=false)
     */
    private $name;

    /**
     * @var string
     *
     * @ORM\Column(name="description", type="string", length=255, nullable=false)
     */
    private $description;

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * @param string $description
     */
    public function setDescription($description)
    {
        $this->description = $description;
    }
}
