<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Subscribers\Backend;

use Shopware\Models\Article\Detail as ArticleDetail;
use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base;

class BackendBaseSubscriber extends Base
{
    /**
     * @return An array containing all subscriptions.
     */
    public static function getSubscribedEvents()
    {
        return [
            'Shopware_Controllers_Backend_Base::getVariantsAction::after' => 'afterGetVariantAction',
        ];
    }

    /**
     * If you add a position dynamically in the positions tab, our Order hook onAfterGetList is not executed. Add
     * custom attributes here.
     *
     * @param \Enlight_Hook_HookArgs $args
     */
    public function afterGetVariantAction(\Enlight_Hook_HookArgs $args)
    {
        $data = $args->getSubject()->View()->getAssign('data');
        $data = $this->addCustomArticleDetailData($data);
        $args->getSubject()->View()->assign('data', $data);
    }

    /**
     * Adds all relevant article properties that where defined in the variant model (backend/base/model/variant)
     *
     * @param array $variants
     * @return array
     */
    private function addCustomArticleDetailData(array $variants)
    {
        // Use one query to improve performance
        $articleDetails = $this->get('models')->getRepository(ArticleDetail::class)->findBy([
            'id' => array_column($variants, 'id'),
        ]);

        foreach ($articleDetails as $articleDetail) {
            foreach ($variants as &$variant) {
                if (intval($variant['id']) === $articleDetail->getId()) {
                    $variant['pickwareStockManagementDisabled'] = $articleDetail->getAttribute() && $articleDetail->getAttribute()->getPickwareStockManagementDisabled();
                    break;
                }
            }
        }

        return $variants;
    }
}
