<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Subscribers\Backend;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base;

class BackendIndexSubscriber extends Base
{

    /**
     * @return An array containing all subscriptions.
     */
    public static function getSubscribedEvents()
    {
        return [
            /* Responsible for snippets and views.
             *
             * The high priority value is necessary to ensure the JavaScript files are loaded after the ones from
             * the ViisonArticleAnalytics plugin. Because they override some of the same methods in Shopware's analytics
             * code, the order of overrides is important. This is at least necessary as of 2016-01-16,
             * ViisonArticleAnalytics v1.0.10. Without it, ViisonArticleAnalytics' override of
             * Shopware.apps.Analytics.controller.Main#renderDataOutput takes precedence and Pickware's override in
             * Shopware.apps.ViisonCommonAnalytics.controller.Main will never be called. */
            'Enlight_Controller_Action_PostDispatch_Backend_Index' => [
                'onPostDispatchIndex',
                999,
            ],
        ];
    }

    public function onPostDispatchIndex(\Enlight_Event_EventArgs $args)
    {
        $subject = $args->getSubject();

        /* Execute $this->onSecurePostDispatchIndex, here, if the conditions for a secure post dispatch hold
         * The conditions checked are the same as in \Enlight_Controller_Action#dispatch, which usually would fire that
         * event. */
        if ($subject->Request()->isDispatched()
            && !$subject->Response()->isException()
            && $subject->View()->hasTemplate()) {
            $this->onSecurePostDispatchIndex($args);
        }
    }

    /**
     * Loads common snippets and views used across different components in the backend.
     *
     * @param args The arguments passed by the method triggering the event.
     */
    private function onSecurePostDispatchIndex(\Enlight_Event_EventArgs $args)
    {
        $view = $args->getSubject()->View();
        // Load backend modules and custom resources
        $view->extendsTemplate('backend/viison_pickware_erp/base/header.tpl');
    }
}
