<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Subscribers\Backend;

use Shopware\Models\Document\Document;
use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base;

class BackendMailSubscriber extends Base
{
    /**
     * @inheritdoc
     */
    public static function getSubscribedEvents()
    {
        return [
            'Shopware_Controllers_Backend_Mail::getMailsAction::after' => 'onAfterGetMailsAction',
        ];
    }

    /**
     * Adjusts the names of the document mailer templates to include the actual, localized name of the document types
     * instead of their ID.
     *
     * @param \Enlight_Hook_HookArgs $args
     */
    public function onAfterGetMailsAction(\Enlight_Hook_HookArgs $args)
    {
        $subject = $args->getSubject();
        $data = $subject->View()->data;

        $snippetNamespace = $this->get('viison_common.snippet_manager')->getNamespace('mails/viison_pickware_erp');
        $pickwareDocumentPrefix = $snippetNamespace->get('document_mailer/prefix');
        $userEmails = $data[2];
        foreach ($userEmails['data'] as &$userEmail) {
            if (preg_match('/ViisonPickwareERPCommonDocumentMailerEMail_DocType(\\d+)/', $userEmail['name'], $matches)) {
                $documentId = $matches[1];
                $document = $this->get('models')->find(Document::class, $documentId);
                if ($document) {
                    $userEmail['name'] = $pickwareDocumentPrefix . ' - ' . $document->getName();
                }
            } elseif ($userEmail['name'] === 'ViisonPickwareERPCommonDocumentMailerEMail_archive') {
                $userEmail['name'] = $snippetNamespace->get('invoice_archive');
            }
        }

        $data[2] = $userEmails;
        $subject->View()->data = $data;
    }
}
