<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Subscribers\Backend;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base;

class PluginTestNotificationSubscriber extends Base
{
    /**
     * @return array
     */
    public static function getSubscribedEvents()
    {
        return [
            'ViisonCommon_SubApplicationRegistration' => 'onSubApplicationRegistration',
            'Enlight_Controller_Dispatcher_ControllerPath_Backend_ViisonPickwareERPIndexPluginTestCheck' => 'onGetControllerPath',
        ];
    }

    /**
     * @param \Enlight_Event_EventArgs $args
     */
    public function onSubApplicationRegistration(\Enlight_Event_EventArgs $args)
    {
        Shopware()->Container()->get('ViisonCommonJSLoader')->registerSubApplication(
            'ViisonPickwareERPIndexPluginTestCheck',
            $this->getPluginPath(),
            [],
            'Index',
            []
        );
    }

    /**
     * @param \Enlight_Event_EventArgs $args
     * @return string
     */
    public function onGetControllerPath(\Enlight_Event_EventArgs $args)
    {
        return $this->getPluginPath() . 'Controllers/Backend/ViisonPickwareERPIndexPluginTestCheck.php';
    }
}
