<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Subscribers\Backend;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Backend\VariantGeneration as AbstractVariantGenerationSubscriber;

class VariantGenerationSubscriber extends AbstractVariantGenerationSubscriber
{
    /**
     * @inheritdoc
     */
    protected function getBlockedArticleDetailFields()
    {
        return [
            'inStock' => 0,
            'stockMin' => 0,
        ];
    }

    /**
     * @inheritdoc
     */
    protected function getBlockedArticleAttributeFields()
    {
        return [
            'pickwareIncomingStock' => 0,
            'pickwarePhysicalStockForSale' => 0,
            'pickwareStockInitialized' => false,
            'pickwareStockInitializationTime' => null,
        ];
    }

    /**
     * @inheritdoc
     */
    protected function getBlockedArticleAttributeFieldsMappingOnly()
    {
        return [
            'pickwareStockManagementDisabled'
        ];
    }

    /**
     * @inheritdoc
     */
    protected function getCopiedArticleAttributeFields()
    {
        return [
            'pickwareStockManagementDisabled'
        ];
    }

    /**
     * @inheritdoc
     */
    protected function processGeneratedVariants(array $variants)
    {
        // Initialize the stock of all variants
        $this->get('pickware.erp.stock_initialization_service')->initializeStocksOfArticleDetails($variants);
    }
}
