<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Subscribers\BarcodeLabel;

use Enlight_Event_EventArgs;
use Shopware\Plugins\ViisonCommon\Classes\Subscribers\AbstractBaseSubscriber;
use Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel\Article\ArticleBarcodeLabelType;

class ArticleBarcodeLabelTypeSubscriber extends AbstractBaseSubscriber
{
    /**
     * @inheritdoc
     */
    public static function getSubscribedEvents()
    {
        return [
            'Shopware_Plugins_ViisonPickwareERP_CollectSupportedBarcodeLabelTypes' => 'onCollectSupportedBarcodeLabelTypes',
        ];
    }

    /**
     * Returns the barcode label types supported by this plugin.
     *
     * @param Enlight_Event_EventArgs $args
     * @return ArticleBarcodeLabelType
     */
    public function onCollectSupportedBarcodeLabelTypes(Enlight_Event_EventArgs $args)
    {
        return new ArticleBarcodeLabelType(
            $this->get('models'),
            $this->get('pickware.erp.plugin_config_service'),
            $this->get('snippets'),
            $this->get('pickware.erp.barcode_label.barcode_renderer_service'),
            $this->get('viison_common.image_service')
        );
    }
}
