<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Subscribers;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\CompatibilityCheck as AbstractCompatibilityCheckSubscriber;
use Shopware\Plugins\ViisonCommon\Structs\PluginCompatibilityConstraint;

class CompatibilityCheckSubscriber extends AbstractCompatibilityCheckSubscriber
{
    /**
     * @inheritdoc
     */
    public function getPluginCompatibilityConstraints()
    {
        return [
            new PluginCompatibilityConstraint(
                'Backend',
                'ViisonCoupon',
                '3.4.0' // minimum version
            ),
            new PluginCompatibilityConstraint(
                'Core',
                'ViisonPickwareMobile',
                '5.10.1' // minimum version
            ),
            new PluginCompatibilityConstraint(
                'Core',
                'ViisonPickwarePOS',
                '5.5.0' // minimum version
            ),
            new PluginCompatibilityConstraint(
                'Backend',
                'CoeArticleStock',
                '9999.9999.9999', // mark as "incompatible"
                'Das Plugin "Lagerbestand Protokoll" ist nicht kompatibel mit Pickware. Bitte deaktivieren oder deinstallieren Sie das Plugin.'
            ),
            // Pixeleyes Individuelle Optionen 1.5.4 causes Pickware to prevent orders from opening in the backend because it removes this line:
            // https://github.com/shopware/shopware/blob/fa8fb50f277250c8baff3578d3873f6fbd354739/themes/Backend/ExtJs/backend/order/view/detail/position.js#L271
            new PluginCompatibilityConstraint(
                'Frontend',
                'Pixeloptions',
                '1.5.5',
                'Das Plugin "Pixeleyes Artikeloptionen für Shopware 5" ist bis einschließlich Version 1.5.4 inkompatibel mit Pickware. Bitte aktualisieren Sie das Plugin auf eine neuere Version oder deaktivieren Sie es.'
            ),
            // SetArticles 1.3.19 to make GrossProfitAnalytics work properly
            new PluginCompatibilityConstraint(
                'Core',
                'ViisonSetArticles',
                '1.5.0' // Minimum version
            ),
            // SofortPayment causes stock errors and is not maintained anymore
            new PluginCompatibilityConstraint(
                'Frontend',
                'SofortPayment',
                '9999.9999.9999', // Mark as "incompatible"
                'Das Plugin "SOFORT AG Shopware Module" ist nicht kompatibel mit Pickware. Bitte deaktivieren oder deinstallieren Sie das Plugin und verwenden Sie stattdessen das Plugin "Sofort. für Shopware 5.2.13 und höher".'
            ),
            // GiroCheckout causes problems when canceling order positions and when editing certain order position (e.g. change payment method)
            new PluginCompatibilityConstraint(
                'Frontend',
                'GsagGiroCheckout',
                '3.1.2'
            ),
            // Mbdus Artikel Im-/Export causes problem with the initialization of articles
            new PluginCompatibilityConstraint(
                'Backend',
                'MbdusArticleImportExport',
                '9999.9999.9999',
                'Das Plugin "Mbdus Artikel Im-/Export" ist nicht kompatibel mit Pickware. Bitte deaktivieren oder deinstallieren Sie das Plugin.'
            ),
            new PluginCompatibilityConstraint(
                'Backend',
                'MbdusArticleImportExportOrig',
                '9999.9999.9999',
                'Das Plugin "Mbdus Artikel Im-/Export" ist nicht kompatibel mit Pickware. Bitte deaktivieren oder deinstallieren Sie das Plugin.'
            ),
            // Dreischild Set Artikel-Konfigurator adds order positions wrongly which caused wrong stock entries when
            // shipping an order. This bug is present up to version 2.4.9.
            // More information https://github.com/VIISON/ShopwarePickwareERP/issues/1190
            new PluginCompatibilityConstraint(
                'Frontend',
                'DreiscSetConfig',
                '2.4.10' // minimum version
            ),
            // Blauband E-Mails 1.2.3 causes the EntitiyManager to crash when it tries to flush a custom mail model with no from address given
            new PluginCompatibilityConstraint(
                'ShopwarePlugins',
                'BlaubandEmail',
                '1.2.4',
                'Das Plugin "Blauband E-Mails (EKS)" ist bis einschließlich Version 1.2.3 inkompatibel mit Pickware. Bitte aktualisieren Sie das Plugin auf eine neuere Version oder deaktivieren Sie es.'
            ),
            // The function of "Automatische Zahlungserinnerung und Mahnungen" to automatically correct the stock when
            // an order is canceled is not compatible with ERP and creates stock inconsistencies.
            // More information https://github.com/pickware/ShopwarePickwareERP/issues/1324
            new PluginCompatibilityConstraint(
                'Backend',
                'CoePayReminderCron',
                '17.5.1',
                'Das Plugin "Automatische Zahlungserinnerung und Mahnungen" ist bis einschließlich Version 17.5.0 inkompatibel mit Pickware. Bitte aktualisieren Sie das Plugin auf eine neuere Version oder deaktivieren Sie es.'
            ),
            // The function of "Artikel im Warenkorb (für bestimmte Zeit) reservieren" to automatically reserve
            // items in the cart is not compatible with ERP and creates stock inconsistencies.
            // More information https://github.com/pickware/ShopwarePickwareERP/issues/1369
            new PluginCompatibilityConstraint(
                'Backend',
                'kunkurrenzReserveCart',
                '9999.9999.9999',
                'Das Plugin "Artikel im Warenkorb (für bestimmte Zeit) reservieren" ist nicht kompatibel mit Pickware. Bitte deaktivieren oder deinstallieren Sie das Plugin.'
            ),
            // The plugin "Kopien (CC und BCC) ausgehender E-Mails erhalten" disturbs the overwrite protection
            // for orders and can therefore lead to problems with stock management and stock inconsistencies.
            // More information https://github.com/pickware/ShopwarePickwareERP/issues/1382
            new PluginCompatibilityConstraint(
                'Backend',
                'BlmediaAddBccToOutgoingMails',
                '9999.9999.9999',
                'Das Plugin "Kopien (CC und BCC) ausgehender E-Mails erhalten" ist nicht kompatibel mit Pickware. Bitte deaktivieren oder deinstallieren Sie das Plugin.'
            ),
            // The plugin "Storno mit automatischer Bestandskorrektur" cancels orders in a way
            // that is not compatible with ERP so that stock reservations of orders are never resolved.
            // More information https://github.com/pickware/ShopwarePickwareERP/issues/1370
            new PluginCompatibilityConstraint(
                'Backend',
                'CoeStornoBestellung',
                '9999.9999.9999',
                'Das Plugin "Storno mit automatischer Bestandskorrektur" ist nicht kompatibel mit Pickware. Bitte deaktivieren oder deinstallieren Sie das Plugin.'
            ),
        ];
    }
}
