<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Subscribers;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Controllers as AbstractControllersSubscriber;

class ControllersSubscriber extends AbstractControllersSubscriber
{
    /**
     * @see \Shopware\Plugins\ViisonCommon\Classes\Subscribers\Controllers::getControllerNames()
     */
    public static function getControllerNames()
    {
        return [
            static::MODULE_API => [
                'ViisonPickwareERPBinLocations',
                'ViisonPickwareERPOrderDetails',
                'ViisonPickwareERPOrders',
                'ViisonPickwareERPStock',
                'ViisonPickwareERPWarehouses',
            ],
            static::MODULE_BACKEND => [
                'ViisonPickwareERPArticleBinLocationList',
                'ViisonPickwareERPArticleOrders',
                'ViisonPickwareERPArticleStock',
                'ViisonPickwareERPArticleSupplierAssignment',
                'ViisonPickwareERPArticleSupplierOrderList',
                'ViisonPickwareERPAboutBackend',
                'ViisonPickwareERPAboutContact',
                'ViisonPickwareERPAboutDocumentation',
                'ViisonPickwareERPAboutPopup',
                'ViisonPickwareERPAnalyticsArticle',
                'ViisonPickwareERPAnalyticsGrossProfit',
                'ViisonPickwareERPAnalyticsMainShopCategory',
                'ViisonPickwareERPAnalyticsNetRevenue',
                'ViisonPickwareERPAnalyticsReturns',
                'ViisonPickwareERPAnalyticsSalesRatio',
                'ViisonPickwareERPAnalyticsStockMovements',
                'ViisonPickwareERPAnalyticsStockTurnoverRate',
                'ViisonPickwareERPApiLog',
                'ViisonPickwareERPArticleOrders',
                'ViisonPickwareERPArticleStock',
                'ViisonPickwareERPArticleSupplierAssignment',
                'ViisonPickwareERPArticleSupplierOrderList',
                'ViisonPickwareERPArticleWarehouseFieldSet',
                'ViisonPickwareERPBarcodeLabelPresets',
                'ViisonPickwareERPBarcodeLabelPrinting',
                'ViisonPickwareERPBinLocationEditor',
                'ViisonPickwareERPCancellation',
                'ViisonPickwareERPCustomerArticles',
                'ViisonPickwareERPIndexNewsWidget',
                'ViisonPickwareERPIndexStockCheck',
                'ViisonPickwareERPOrderDocumentCreation',
                'ViisonPickwareERPOrderDocumentDeletion',
                'ViisonPickwareERPOrderDocumentMailer',
                'ViisonPickwareERPOrderReturnShipment',
                'ViisonPickwareERPPluginManagerPickwareModules',
                'ViisonPickwareERPPurchasePriceConverter',
                'ViisonPickwareERPPurchasePriceHelper',
                'ViisonPickwareERPStockValuation',
                'ViisonPickwareERPReturnShipment',
                'ViisonPickwareERPStockInitialization',
                'ViisonPickwareERPStockOverview',
                'ViisonPickwareERPStockTakeExport',
                'ViisonPickwareERPSupplierCommon',
                'ViisonPickwareERPSupplierManagement',
                'ViisonPickwareERPSupplierOrders',
                'ViisonPickwareERPSystemInfo',
                'ViisonPickwareERPWarehouseManagement',
            ],
        ];
    }
}
