<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Subscribers\Doctrine;

use Shopware\Models\Order\Order;
use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base;

/**
 * Subscriber that registers a custom doctrine event Subscriber which is required to implement order overwrite
 * protection while https://github.com/shopware/shopware/pull/1474 is not merged yet.
 */
class DoctrineSubscriberRegistrationSubscriber extends Base
{
    /**
     * @return array
     */
    public static function getSubscribedEvents()
    {
        return [
            'Enlight_Controller_Front_DispatchLoopStartup' => 'registerDoctrineSubscriber',
        ];
    }

    /**
     * Since Shopware does not expose Doctrine's onFlush event, and that's the only event where we can safely implement
     * change time tracking as part of the Order Attribute, we need to register a custom Doctrine EventSubscriber.
     */
    public function registerDoctrineSubscriber()
    {
        // https://github.com/shopware/shopware/pull/1474 was merged, so this is no longer required
        if (method_exists(Order::class, 'getChanged')) {
            return;
        }

        $this->get('model_event_manager')->addEventSubscriber(new DoctrineEventSubscriber());
    }
}
