<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Subscribers\Frontend;

use Shopware\Models\Order\Detail as OrderDetail;
use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base;

class FrontendAccountSubscriber extends Base
{
    /**
     * @inheritdoc
     */
    public static function getSubscribedEvents()
    {
        return [
            'Shopware_Controllers_Frontend_Account::ordersAction::after' => 'onAfterOrdersAction',
        ];
    }

    /**
     * Adds the canceled quantity to each order item of the responded orders.
     *
     * @param \Enlight_Hook_HookArgs $args
     */
    public function onAfterOrdersAction(\Enlight_Hook_HookArgs $args)
    {
        // Append the canceled quantity to each order item
        $view = $args->getSubject()->View();
        $orders = $view->sOpenOrders;
        foreach ($orders as &$order) {
            foreach ($order['details'] as &$detail) {
                $orderDetail = $this->get('models')->find(OrderDetail::class, $detail['id']);
                $canceled = ($orderDetail->getAttribute()) ? $orderDetail->getAttribute()->getPickwareCanceledQuantity() : 0;
                $detail['viison_canceled'] = intval($canceled);
            }
        }
        $view->sOpenOrders = $orders;
    }
}
