<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Subscribers\MediaBundle;

use Doctrine\Common\Collections\ArrayCollection;
use Enlight_Event_EventArgs;
use Shopware\Bundle\MediaBundle\Struct\MediaPosition;
use Shopware\Plugins\ViisonCommon\Classes\ExceptionHandling\SubscriberExceptionHandling;
use Shopware\Plugins\ViisonCommon\Classes\Subscribers\AbstractBaseSubscriber;

class GarbageCollectorSubscriber extends AbstractBaseSubscriber
{
    use SubscriberExceptionHandling;

    /**
     * @inheritDoc
     */
    public static function getSubscribedEvents()
    {
        return [
            'Shopware_Collect_MediaPositions' => 'onCollectMediaPositions',
        ];
    }

    /**
     * @param Enlight_Event_EventArgs $args
     * @return ArrayCollection
     */
    public function onCollectMediaPositions(Enlight_Event_EventArgs $args)
    {
        try {
            return new ArrayCollection([
                new MediaPosition('pickware_erp_return_shipment_attachments', 'mediaId'),
            ]);
        } catch (\Exception $e) {
            $this->handleException($e, $args);

            return null;
        }
    }
}
