<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Subscribers;

use Shopware\Plugins\ViisonCommon\Components\Migration\AbstractPluginMigrationSubscriber;
use Shopware\Plugins\ViisonCommon\Migrations\DocumentNameToDocumentKeyMigration;
use Shopware\Plugins\ViisonPickwareERP\Migrations\DocumentMailTemplatesToBuiltInMailTemplatesMigration;
use \Shopware_Plugins_Core_ViisonPickwareERP_Bootstrap as ErpBootstrap;

class MigrationSubscriber extends AbstractPluginMigrationSubscriber
{
    /**
     * @var ErpBootstrap
     */
    private $erpBootstrap;

    /**
     * @param ErpBootstrap $erpBootstrap
     */
    public function __construct(ErpBootstrap $erpBootstrap)
    {
        $this->erpBootstrap = $erpBootstrap;

        parent::__construct($erpBootstrap);
    }

    /**
     * @inheritdoc
     */
    public function createMigrations()
    {
        $db = $this->get('db');

        $this->addMigration(
            '001_DocumentTypeNameToKey_SupplierOrderDocument',
            new DocumentNameToDocumentKeyMigration(
                ErpBootstrap::SUPPLIER_ORDER_DOCUMENT_TEMPLATE_NAME,
                ErpBootstrap::SUPPLIER_ORDER_DOCUMENT_TEMPLATE_KEY,
                $db
            )
        );
        $this->addMigration(
            '002_DocumentTypeNameToKey_PickListDocument',
            new DocumentNameToDocumentKeyMigration(
                ErpBootstrap::PICK_LIST_DOCUMENT_TYPE_NAME,
                ErpBootstrap::PICK_LIST_DOCUMENT_TYPE_KEY,
                $db
            )
        );

        $this->addMigration(
            '003_DocumentMailTemplatesToBuiltInMailTemplates',
            new DocumentMailTemplatesToBuiltInMailTemplatesMigration(
                $db,
                $this->erpBootstrap->getPlugin(),
                $this->erpBootstrap->getBootstrapSnippetManager()
            )
        );
    }
}
