<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Subscribers\Models;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base;

class ArticleAttributeEntityLifecycleSubscriber extends Base
{
    /**
     * @return array
     */
    public static function getSubscribedEvents()
    {
        return [
            'Shopware\\Models\\Attribute\\Article::prePersist' => 'onPreSave',
            'Shopware\\Models\\Attribute\\Article::preUpdate' => 'onPreSave',
        ];
    }

    /**
     * Checks all custom attributes field that are known to have a NOT NULL constraint
     * and makes sure the value that is about to be saved is not NULL. That is, if a NULL
     * value is found, it is replaced with the respective default value.
     *
     * @param args The arguments passed by the method triggering the hook.
     */
    public function onPreSave(\Enlight_Event_EventArgs $args)
    {
        // Define the respective default values
        $defaultValues = [
            'pickwareStockManagementDisabled' => false,
            'pickwareIncomingStock' => 0,
            'pickwarePhysicalStockForSale' => 0,
        ];

        // Make sure that all custom attributes having NOT NULL constraints
        // are not NULL and, if they are, set them to their respective default value
        $entity = $args->get('entity');
        foreach ($defaultValues as $field => $value) {
            $getterName = 'get' . ucfirst($field);
            if ($entity->$getterName() === null) {
                $setterName = 'set' . ucfirst($field);
                $entity->$setterName($value);
            }
        }
    }
}
