<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Subscribers\Models;

use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base;

class ArticleDetailEntityLifecycleSubscriber extends Base
{
    /**
     * @return array
     */
    public static function getSubscribedEvents()
    {
        return [
            'Shopware\\Models\\Article\\Detail::preRemove' => 'onPreRemove',
        ];
    }

    /**
     * Removes/updates the following entities that are associated with the article detail that
     * is being removed:
     *  - Sets the article detail ID of respective supplier order items to NULL
     *  - Removes supplier order items whose supplierOrderId and articleDetailId are both NULL
     *
     * @param args The arguments passed by the method triggering the hook.
     */
    public function onPreRemove(\Enlight_Event_EventArgs $args)
    {
        // Remove the article (detail) ID from all respective supplier order items
        $articleDetailId = $args->get('entity')->getId();
        $dql = 'UPDATE Shopware\\CustomModels\\ViisonPickwareERP\\SupplierOrder\\SupplierOrderItem supplierOrderItem
                SET supplierOrderItem.articleDetailId = NULL
                WHERE supplierOrderItem.articleDetailId = :articleDetailId';
        $this->get('models')
            ->createQuery($dql)
            ->setParameter('articleDetailId', $articleDetailId)
            ->execute();

        // Remove those supplier order items, which are neither associated with an order (pre-assigned article),
        // nor with an article detail
        $dql = 'DELETE Shopware\\CustomModels\\ViisonPickwareERP\\SupplierOrder\\SupplierOrderItem supplierOrderItem
                WHERE supplierOrderItem.supplierOrderId IS NULL
                AND supplierOrderItem.articleDetailId IS NULL';
        $this->get('models')
            ->createQuery($dql)
            ->execute();
    }
}
