<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Subscribers\Models;

use Shopware\CustomModels\ViisonPickwareERP\Warehouse\Warehouse;
use Shopware\Models\Article\Detail as ArticleDetail;
use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Base;

class OrderDetailEntityLifecycleSubscriber extends Base
{
    /**
     * @return array
     */
    public static function getSubscribedEvents()
    {
        return [
            'Shopware\\Models\\Order\\Detail::postRemove' => 'onRemoveOrderDetail',
        ];
    }

    /**
     * Recalculates the cached reserved stocks for the article detail, associated with the removed order detail, in all
     * warehouses.
     *
     * @param \Enlight_Event_EventArgs $args
     */
    public function onRemoveOrderDetail(\Enlight_Event_EventArgs $args)
    {
        // Check whether the order detail as an associated article detail
        $orderDetail = $args->get('entity');
        $articleDetail = $this->get('models')->getRepository(ArticleDetail::class)->findOneBy([
            'number' => $orderDetail->getArticleNumber(),
        ]);
        if (!$articleDetail) {
            return;
        }

        // Update the article detail's cached reserved stock in all warehouses
        $derivedPropertyUpdater = $this->get('pickware.erp.derived_property_updater_service');
        $allWarehouses = $this->get('models')->getRepository(Warehouse::class)->findAll();
        foreach ($allWarehouses as $warehouse) {
            $derivedPropertyUpdater->recalculateReservedStockForArticleDetailInWarehouse($articleDetail, $warehouse);
        }
    }
}
