<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Subscribers;

use Shopware\Plugins\ViisonPickwareERP\Components\RestApi\RequestLogging\AbstractRestApiRequestLogFilterSubscriber;

class RestApiRequestLogFilterSubscriber extends AbstractRestApiRequestLogFilterSubscriber
{
    /**
     * @inheritdoc
     */
    public function filterLoggedResponseJson(array $responseJson, \Enlight_Controller_Request_Request $request)
    {
        // Don't filter anything
        return $responseJson;
    }

    /**
     * @inheritdoc
     */
    public function shouldLogRequest(\Enlight_Controller_Request_RequestHttp $request)
    {
        // Whitelist all requests routed to any of the Pickware (ERP, Mobile, POS, Common etc.) REST API controllers
        return mb_strpos($request->getControllerName(), 'ViisonPickware') === 0;
    }
}
