<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Subscribers;

use Shopware\Plugins\ViisonPickwareERP\Components\RestApi\Routing\AbstractRestApiRouterSubscriber;

class RestApiRouterSubscriber extends AbstractRestApiRouterSubscriber
{
    /**
     * @inheritDoc
     */
    public function applyCustomRouting(\Enlight_Controller_Request_Request $request)
    {
        $controllerName = $request->getControllerName();
        $actionName = $request->getActionName();
        $method = $request->getMethod();

        if ($controllerName === 'binLocations'
            && (
                ($method === 'GET' && ($actionName === 'index' || $actionName === 'get'))
                || ($method === 'POST' && $actionName === 'post')
                || ($method === 'PUT' && $actionName === 'put')
                || ($method === 'DELETE' && $actionName === 'delete')
            )
        ) {
            return 'ViisonPickwareERPBinLocations';
        }

        if ($controllerName === 'orderDetails' && $method === 'PUT' && $request->getParam('id') === 'ship') {
            return 'ViisonPickwareERPOrderDetails';
        }

        if ($controllerName === 'orders' && $method === 'PUT' && $actionName === 'putShip') {
            return 'ViisonPickwareERPOrders';
        }

        if ($controllerName === 'stock' && $method === 'PUT' && in_array($request->getParam('id'), ['set', 'change', 'relocate'])) {
            return 'ViisonPickwareERPStock';
        }

        if ($controllerName === 'warehouses'
            && (
                ($method === 'GET' && ($actionName === 'index' || $actionName === 'get'))
                || ($method === 'POST' && $actionName === 'post')
                || ($method === 'PUT' && $actionName === 'put')
                || ($method === 'DELETE' && $actionName === 'delete')
            )
        ) {
            return 'ViisonPickwareERPWarehouses';
        }

        return null;
    }
}
