<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Subscribers;

use Enlight_Class;
use Enlight_Config;
use Shopware\Components\DependencyInjection\Container;
use Shopware\Plugins\ViisonCommon\Classes\Subscribers\Services as AbstractServicesSubscriber;
use Shopware\Plugins\ViisonPickwareERP\Components\StockValuation\StockValuationService;
use Shopware\Plugins\ViisonPickwareERP\Components\RestApi\RequestLogging\RestApiRequestLoggerService;
use Shopware\Plugins\ViisonPickwareERP\Components\RestApi\Routing\RestApiRouterService;
use Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel\BarcodeLabelPresetsService;
use Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel\BarcodeLabelRendererService;
use Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel\BarcodeLabelFacadeService;
use Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel\BarcodeLabelTemplatesService;
use Shopware\Plugins\ViisonPickwareERP\Components\BarcodeLabel\BarcodeRendererService;
use Shopware\Plugins\ViisonPickwareERP\Components\Cancellation\OrderCancelerService;
use Shopware\Plugins\ViisonPickwareERP\Components\RestApi\Idempotency\RestApiIdempotencyService;
use Shopware\Plugins\ViisonPickwareERP\Components\OrderDetailQuantityCalculator\OrderDetailQuantityCalculatorService;
use Shopware\Plugins\ViisonPickwareERP\Components\OrderDetailQuantityValidator\OrderDetailQuantityValidatorService;
use Shopware\Plugins\ViisonPickwareERP\Components\PluginConfig\PluginConfigService;
use Shopware\Plugins\ViisonPickwareERP\Components\DerivedPropertyUpdater\DerivedPropertyUpdaterService;
use Shopware\Plugins\ViisonPickwareERP\Components\Document\DocumentMailingService;
use Shopware\Plugins\ViisonPickwareERP\Components\Document\OrderDocumentCreationService;
use Shopware\Plugins\ViisonPickwareERP\Components\Document\PickListDocumentCreationService;
use Shopware\Plugins\ViisonPickwareERP\Components\Document\InvoiceArchiveService;
use Shopware\Plugins\ViisonPickwareERP\Components\RestApi\RestApiArticleDetailUpdaterService;
use Shopware\Plugins\ViisonPickwareERP\Components\StockLedger\ArticleDetailConcurrencyCoordinatorService;
use Shopware\Plugins\ViisonPickwareERP\Components\StockMovement\StockLocationFactoryService;
use Shopware\Plugins\ViisonPickwareERP\Components\ReturnShipment\ReturnShipmentMailingService;
use Shopware\Plugins\ViisonPickwareERP\Components\ReturnShipment\ReturnShipmentProcessorService;
use Shopware\Plugins\ViisonPickwareERP\Components\StockLedger\ArticleDetailStockInfoProviderService;
use Shopware\Plugins\ViisonPickwareERP\Components\StockLedger\StockChangeList\StockChangeListFactoryService;
use Shopware\Plugins\ViisonPickwareERP\Components\StockLedger\StockInitializationService;
use Shopware\Plugins\ViisonPickwareERP\Components\StockLedger\StockItemUpdaterService;
use Shopware\Plugins\ViisonPickwareERP\Components\StockLedger\StockLedgerService;
use Shopware\Plugins\ViisonPickwareERP\Components\StockLedger\StockUpdaterService;
use Shopware\Plugins\ViisonPickwareERP\Components\StockReservation\StockReservationService;
use Shopware\Plugins\ViisonPickwareERP\Components\Supplier\SupplierNumberGeneratorService;
use Shopware\Plugins\ViisonPickwareERP\Components\Warehouse\BinLocationCodeGeneratorService;
use Shopware\Plugins\ViisonPickwareERP\Components\Warehouse\WarehouseIntegrityService;

class ServicesSubscriber extends AbstractServicesSubscriber
{
    /**
     * {@inheritdoc}
     *
     * Note: We use {@link Enlight_Class::getClassName()} to create the effective class name for each service we
     * instantiate. This allows hooking their `public` and `protected` methods without the need of decorating the
     * whole service.
     */
    public static function getServices()
    {
        return [
            'pickware.erp.article_detail_stock_info_provider_service' => function (Container $container) {
                $className = Enlight_Class::getClassName(ArticleDetailStockInfoProviderService::class);

                return new $className(
                    $container->get('models')
                );
            },
            'pickware.erp.article_detail_concurrency_coordinator_service' => function (Container $container) {
                $className = Enlight_Class::getClassName(ArticleDetailConcurrencyCoordinatorService::class);

                return new $className(
                    $container->get('dbal_connection')
                );
            },
            'pickware.erp.bin_location_code_generator_service' => function () {
                $className = Enlight_Class::getClassName(BinLocationCodeGeneratorService::class);

                return new $className();
            },
            'pickware.erp.barcode_label_service' => function (Container $container) {
                $className = Enlight_Class::getClassName(BarcodeLabelFacadeService::class);

                return new $className(
                    $container->get('events'),
                    $container->get('pickware.erp.barcode_label.templates_service'),
                    $container->get('pickware.erp.barcode_label.presets_service'),
                    $container->get('pickware.erp.barcode_label.renderer_service')
                );
            },
            'pickware.erp.barcode_label.barcode_renderer_service' => function () {
                $className = Enlight_Class::getClassName(BarcodeRendererService::class);

                return new $className();
            },
            'pickware.erp.barcode_label.presets_service' => function (Container $container) {
                $className = Enlight_Class::getClassName(BarcodeLabelPresetsService::class);

                return new $className(
                    $container->get('models'),
                    $container->get('pickware.erp.barcode_label.templates_service')
                );
            },
            'pickware.erp.barcode_label.renderer_service' => function (Container $container) {
                $className = Enlight_Class::getClassName(BarcodeLabelRendererService::class);

                return new $className(
                    $container->get('pickware.erp.barcode_label.templates_service'),
                    $container->get('viison_common.document_rendering_context_factory'),
                    $container->get('pickware.erp.plugin_config_service')
                );
            },
            'pickware.erp.barcode_label.templates_service' => function (Container $container) {
                $className = Enlight_Class::getClassName(BarcodeLabelTemplatesService::class);

                return new $className(
                    $container->getParameter('kernel.root_dir'),
                    $container->get('pickware.erp.plugin_config_service')->getPreviewFallbackImagePath()
                );
            },
            'pickware.erp.derived_property_updater_service' => function (Container $container) {
                $className = Enlight_Class::getClassName(DerivedPropertyUpdaterService::class);

                return new $className(
                    $container->get('models'),
                    $container->get('db'),
                    $container->get('pickware.erp.article_detail_stock_info_provider_service')
                );
            },
            'pickware.erp.document_mailing_service' => function (Container $container) {
                $className = Enlight_Class::getClassName(DocumentMailingService::class);

                return new $className(
                    $container->get('models'),
                    $container->get('templatemail'),
                    $container->get('viison_common.document_file_storage_service')
                );
            },
            'pickware.erp.invoice_archive_service' => function (Container $container) {
                $className = Enlight_Class::getClassName(InvoiceArchiveService::class);

                return new $className(
                    $container->get('pickware.erp.plugin_config_service'),
                    $container->get('pickware.erp.document_mailing_service')
                );
            },
            'pickware.erp.order_canceler_service' => function (Container $container) {
                $className = Enlight_Class::getClassName(OrderCancelerService::class);

                return new $className(
                    $container->get('models'),
                    $container->get('pickware.erp.order_detail_quantity_calculator_service')
                );
            },
            'pickware.erp.order_detail_quantity_calculator_service' => function (Container $container) {
                $className = Enlight_Class::getClassName(OrderDetailQuantityCalculatorService::class);

                return new $className(
                    $container->get('models')
                );
            },
            'pickware.erp.order_detail_quantity_validator_service' => function (Container $container) {
                $className = Enlight_Class::getClassName(OrderDetailQuantityValidatorService::class);

                return new $className(
                    $container->get('pickware.erp.order_detail_quantity_calculator_service')
                );
            },
            'pickware.erp.order_document_creation_service' => function (Container $container) {
                $className = Enlight_Class::getClassName(OrderDocumentCreationService::class);

                return new $className(
                    $container->get('models'),
                    $container->get('events'),
                    $container->get('viison_common.document_component_listener_service')
                );
            },
            'pickware.erp.pick_list_document_creation_service' => function (Container $container) {
                $className = Enlight_Class::getClassName(PickListDocumentCreationService::class);

                return new $className(
                    $container->get('models'),
                    $container->get('snippets'),
                    $container->get('pickware.erp.stock_change_list_factory_service')
                );
            },
            'pickware.erp.plugin_config_service' => function (Container $container, Enlight_Config $pluginConfig) {
                $className = Enlight_Class::getClassName(PluginConfigService::class);

                return new $className(
                    $pluginConfig,
                    $container->get('models'),
                    $container->get('viison_common.hidden_config_storage'),
                    $container->getParameter('kernel.root_dir')
                );
            },
            'pickware_erp.stock_valuation_service' => function (Container $container, Enlight_Config $pluginConfig) {
                $className = Enlight_Class::getClassName(StockValuationService::class);

                return new $className(
                    $container->get('models'),
                    $container->get('dbal_connection'),
                    $pluginConfig
                );
            },
            'pickware.erp.rest_api_article_detail_updater_service' => function (Container $container) {
                $className = Enlight_Class::getClassName(RestApiArticleDetailUpdaterService::class);

                return new $className(
                    $container->get('models'),
                    $container->get('pickware.erp.stock_ledger_service'),
                    $container->get('pickware.erp.stock_change_list_factory_service'),
                    $container->get('pickware.erp.derived_property_updater_service')
                );
            },
            'pickware.erp.rest_api_idempotency_service' => function (Container $container) {
                return new RestApiIdempotencyService(
                    $container->get('models'),
                    $container->get('dbal_connection'),
                    $container->get('pickware.erp.rest_api_request_logger_service')
                );
            },
            'pickware.erp.rest_api_request_logger_service' => function (Container $container) {
                return new RestApiRequestLoggerService(
                    $container->get('auth'),
                    $container->get('db'),
                    $container->get('models'),
                    $container->get('events')
                );
            },
            'pickware.erp.rest_api_router_service' => function (Container $container) {
                return new RestApiRouterService($container->get('events'));
            },
            'pickware.erp.return_shipment_mailing_service' => function (Container $container) {
                $className = Enlight_Class::getClassName(ReturnShipmentMailingService::class);

                return new $className(
                    $container->get('models'),
                    $container->get('templatemail')
                );
            },
            'pickware.erp.return_shipment_processor_service' => function (Container $container) {
                $className = Enlight_Class::getClassName(ReturnShipmentProcessorService::class);

                return new $className(
                    $container->get('models'),
                    $container->get('pickware.erp.stock_updater_service'),
                    $container->get('pickware.erp.stock_change_list_factory_service'),
                    $container->get('shopware.number_range_incrementer'),
                    $container->get('pickware.erp.order_canceler_service'),
                    $container->get('pickware.erp.order_detail_quantity_calculator_service')
                );
            },
            'pickware.erp.stock_change_list_factory_service' => function (Container $container) {
                $className = Enlight_Class::getClassName(StockChangeListFactoryService::class);

                return new $className(
                    $container->get('models')
                );
            },
            'pickware.erp.stock_initialization_service' => function (Container $container) {
                $className = Enlight_Class::getClassName(StockInitializationService::class);

                return new $className(
                    $container->get('db'),
                    $container->get('models'),
                    $container->get('pickware.erp.stock_ledger_service'),
                    $container->get('pickware.erp.warehouse_integrity_service')
                );
            },
            'pickware.erp.stock_item_updater_service' => function (Container $container) {
                $className = Enlight_Class::getClassName(StockItemUpdaterService::class);

                return new $className(
                    $container->get('models'),
                    $container->get('pluginlogger')
                );
            },
            'pickware.erp.stock_ledger_service' => function (Container $container) {
                return new StockLedgerService(
                    $container->get('models'),
                    $container->get('snippets'),
                    $container->get('pickware.erp.stock_change_list_factory_service'),
                    $container->get('pickware.erp.derived_property_updater_service'),
                    $container->get('pickware.erp.article_detail_stock_info_provider_service'),
                    $container->get('pickware.erp.article_detail_concurrency_coordinator_service'),
                    $container->get('viison_common.logger')
                );
            },
            'pickware.erp.stock_location_factory_service' => function (Container $container) {
                return new StockLocationFactoryService(
                    $container->get('models'),
                    $container->get('pickware.erp.stock_change_list_factory_service'),
                    $container->get('pickware.erp.stock_updater_service'),
                    $container->get('pickware.erp.stock_ledger_service'),
                    $container->get('pickware.erp.article_detail_stock_info_provider_service')
                );
            },
            'pickware.erp.stock_reservation_service' => function (Container $container) {
                $className = Enlight_Class::getClassName(StockReservationService::class);

                return new $className(
                    $container->get('models'),
                    $container->get('pickware.erp.stock_change_list_factory_service'),
                    $container->get('pickware.erp.derived_property_updater_service'),
                    $container->get('pickware.erp.stock_ledger_service'),
                    $container->get('pickware.erp.order_detail_quantity_calculator_service')
                );
            },
            'pickware.erp.stock_updater_service' => function (Container $container) {
                $className = Enlight_Class::getClassName(StockUpdaterService::class);

                return new $className(
                    $container->get('pickware.erp.stock_ledger_service')
                );
            },
            'pickware.erp.supplier_number_generator_service' => function (Container $container) {
                $className = Enlight_Class::getClassName(SupplierNumberGeneratorService::class);

                return new $className(
                    $container->get('models'),
                    $container->get('snippets')
                );
            },
            'pickware.erp.warehouse_integrity_service' => function (Container $container) {
                $className = Enlight_Class::getClassName(WarehouseIntegrityService::class);

                return new $className(
                    $container->get('models'),
                    $container->get('db'),
                    $container->get('events'),
                    $container->get('snippets')
                );
            },
        ];
    }
}
