<?php
// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

namespace Shopware\Plugins\ViisonPickwareERP\Subscribers;

use Shopware\Models\Order\Order;
use Shopware\Plugins\ViisonCommon\Components\SubApplicationLoading\AbstractSubApplicationRegistrationSubscriber;
use Shopware\Plugins\ViisonCommon\Classes\Util\Util;

class SubApplicationRegistrationSubscriber extends AbstractSubApplicationRegistrationSubscriber
{
    /**
     * @inheritdoc
     */
    public function createSubApplications()
    {
        $this->addModelExtension('ViisonPickwareERPArticleModelExtensions')
            ->extendingSubApplication('Article');
        $this->addModelExtension('ViisonPickwareERPOrderModelExtensions')
            ->extendingSubApplication('Order');
        $this->addModelExtension('ViisonPickwareERPOverviewModelExtensions')
            ->extendingSubApplication('Overview');
        $this->addModelExtension('ViisonPickwareERPBaseModelExtensions')
            ->extendingSubApplication('Base');

        $this->addSubApplication('ViisonPickwareERPAboutBackend')
            ->requiringSubApplication('ViisonCommonIndexPopup');
        $this->addSubApplication('ViisonPickwareERPAboutContact')
            ->requiringSubApplication('ViisonCommonMailComposer');
        $this->addSubApplication('ViisonPickwareERPArticleBinLocationList');
        $this->addSubApplication('ViisonPickwareERPBarcodeLabelPresets')
            ->requiringSubApplication('ViisonCommonEventBus');
        $this->addSubApplication('ViisonPickwareERPBarcodeLabelPrinting')
            ->requiringSubApplications([
                'ViisonCommonGridLabelPrinting',
                'ViisonPickwareERPWarehouseManagement',
                'ViisonCommonPaginationToolbar',
                'ViisonCommonComboBox',
                'ViisonCommonCurrencyFormatter',
            ]);
        $this->addSubApplication('ViisonPickwareERPBinLocationEditor')
            ->requiringSubApplications([
                'ViisonPickwareERPWarehouseManagement',
                'ViisonPickwareERPPurchasePriceHelper',
                'ViisonCommonPaginationToolbar',
            ]);
        $this->addSubApplication('ViisonPickwareERPCancellation')
            ->requiringSubApplication('ViisonCommonGrid')
            ->requiringSubApplication('ViisonCommonData')
            ->requiringSubApplication('ViisonCommonCurrencyFormatter');
        $this->addSubApplication('ViisonPickwareERPOrderDetailQuantityColumnInjector');
        $this->addSubApplication('ViisonPickwareERPPurchasePriceConverter')
            ->requiringSubApplication('ViisonPickwareERPPurchasePriceHelper');
        $this->addSubApplication('ViisonPickwareERPPurchasePriceHelper');
        $this->addSubApplication('ViisonPickwareERPStockValuation')
            ->requiringSubApplications([
                'ViisonCommonCurrencyFormatter',
                'ViisonCommonPaginationToolbar',
                'ViisonPickwareERPWarehouseManagement',
            ]);
        $this->addSubApplication('ViisonPickwareERPMessageBoxWithCheckboxes');
        $this->addSubApplication('ViisonPickwareERPReturnShipment')
            ->requiringSubApplication('ViisonCommonCurrencyFormatter')
            ->requiringSubApplication('ViisonCommonPaginationToolbar')
            ->requiringSubApplication('ViisonCommonStatusTranslator')
            ->requiringSubApplication('ViisonCommonMailComposer')
            ->requiringSubApplication('ViisonCommonGrid')
            ->requiringSubApplication('ViisonCommonData')
            ->requiringSubApplication('ViisonPickwareERPWarehouseManagement')
            ->requiringSubApplication('ViisonPickwareERPMessageBoxWithCheckboxes');

        $this->addSubApplication('ViisonPickwareERPStockInitialization')
            ->requiringSubApplications([
                'ViisonCommonCurrencyFormatter',
                'ViisonPickwareERPPurchasePriceHelper',
                'ViisonCommonPaginationToolbar',
            ]);
        $this->addSubApplication('ViisonPickwareERPStockOverview')
            ->requiringSubApplications([
                'ViisonCommonPaginationToolbar',
                'ViisonPickwareERPArticleBinLocationList',
                'ViisonCommonStatusTranslator',
            ]);

        $this->addSubApplication('ViisonPickwareERPStockTakeExport')
            ->requiringSubApplications([
                'ViisonCommonCurrencyFormatter',
                'ViisonCommonPaginationToolbar',
                'ViisonPickwareERPPurchasePriceHelper',
                'ViisonPickwareERPWarehouseManagement',
                'ViisonCommonGrid',
            ]);

        $this->addSubApplication('ViisonPickwareERPSupplierCommon');
        $this->addSubApplication('ViisonPickwareERPSupplierManagement')
            ->requiringSubApplications([
                'ViisonPickwareERPSupplierCommon',
                'ViisonCommonCurrencyFormatter',
                'ViisonPickwareERPPurchasePriceHelper',
                'ViisonCommonPaginationToolbar',
            ]);
        $this->addSubApplication('ViisonPickwareERPSupplierOrders')
            ->requiringSubApplications([
                'ViisonPickwareERPSupplierManagement',
                'ViisonCommonCurrencyFormatter',
                'ViisonCommonMailComposer',
                'ViisonPickwareERPPurchasePriceHelper',
                'ViisonPickwareERPWarehouseManagement',
                'ViisonCommonPaginationToolbar',
                'ViisonCommonHintPanel',
            ]);
        $this->addSubApplication('ViisonPickwareERPWarehouseManagement')
            ->requiringSubApplications([
                'ViisonCommonComboBox',
                'ViisonCommonPaginationToolbar',
            ]);
        $this->addSubApplication('ViisonPickwareERPApiLog')
            ->requiringSubApplication('ViisonCommonPaginationToolbar');

        $this->addSubApplicationExtension('ViisonPickwareERPOrder')
            ->extendingSubApplication('Order');
        $this->addSubApplicationExtension('ViisonPickwareERPOrderEventBus')
            ->extendingSubApplication('Order');
        $this->addSubApplicationExtension('ViisonPickwareERPConfig')
            ->extendingSubApplication('Config');
        $this->addSubApplicationExtension('ViisonPickwareERPOrderDocumentCreation')
            ->extendingSubApplication('Order')
            ->requiringSubApplication('ViisonPickwareERPOrderEventBus');
        $this->addSubApplicationExtension('ViisonPickwareERPArticleEAN')
            ->extendingSubApplication('Article');
        $this->addSubApplicationExtension('ViisonPickwareERPArticleBarcodeLabelPrinting')
            ->extendingSubApplication('Article')
            ->requiringSubApplication('ViisonPickwareERPArticleWarehouseFieldSet');
        $this->addSubApplicationExtension('ViisonPickwareERPArticleProfitMargin')
            ->extendingSubApplication('Article')
            ->requiringSubApplication('ViisonPickwareERPPurchasePriceHelper');
        $this->addSubApplicationExtension('ViisonPickwareERPArticleListBarcodeLabelPrinting')
            ->extendingSubApplication('Article')
            ->requiringSubApplication('ViisonPickwareERPArticleWarehouseFieldSet');
        $this->addSubApplicationExtension('ViisonPickwareERPArticlePurchasePrice')
            ->extendingSubApplication('Article')
            ->requiringSubApplication('ViisonPickwareERPPurchasePriceHelper');
        $this->addSubApplicationExtension('ViisonPickwareERPArticleListStockColumn')
            ->extendingSubApplication('ArticleList');
        $this->addSubApplicationExtension('ViisonPickwareERPArticleOrders')
            ->extendingSubApplication('Article')
            ->requiringSubApplications([
                'ViisonCommonVariantComboBox',
                'ViisonCommonPaginationToolbar',
                'ViisonCommonStatusTranslator',
            ]);
        $this->addSubApplicationExtension('ViisonPickwareERPArticleStock')
            ->extendingSubApplication('Article')
            ->requiringSubApplications([
                'ViisonCommonCurrencyFormatter',
                'ViisonCommonVariantComboBox',
                'ViisonPickwareERPPurchasePriceHelper',
                'ViisonPickwareERPWarehouseManagement',
                'ViisonCommonPaginationToolbar',
            ]);
        $this->addSubApplicationExtension('ViisonPickwareERPArticleStockFieldSet')
            ->extendingSubApplication('Article');
        $this->addSubApplicationExtension('ViisonPickwareERPArticleSupplierAssignment')
            ->extendingSubApplication('Article')
            ->requiringSubApplications([
                'ViisonPickwareERPSupplierManagement',
                'ViisonCommonCurrencyFormatter',
                'ViisonCommonVariantComboBox',
                'ViisonPickwareERPPurchasePriceHelper',
                'ViisonCommonPaginationToolbar',
            ]);
        $this->addSubApplicationExtension('ViisonPickwareERPArticleSupplierOrderList')
            ->extendingSubApplication('Article')
            ->requiringSubApplications([
                'ViisonPickwareERPSupplierCommon',
                'ViisonPickwareERPSupplierOrders',
                'ViisonCommonVariantComboBox',
                'ViisonCommonPaginationToolbar',
            ]);
        $this->addSubApplicationExtension('ViisonPickwareERPArticleVariantConfigurator')
            ->extendingSubApplication('Article');
        $this->addSubApplicationExtension('ViisonPickwareERPArticleVariantsStockColumn')
            ->extendingSubApplication('Article');
        $this->addSubApplicationExtension('ViisonPickwareERPArticleWarehouseFieldSet')
            ->extendingSubApplication('Article')
            ->requiringSubApplications([
                'ViisonPickwareERPArticleBinLocationList',
                'ViisonPickwareERPBinLocationEditor',
            ]);
        $this->addSubApplicationExtension('ViisonPickwareERPAnalyticsArticle')
            ->extendingSubApplication('Analytics')
            ->requiringSubApplications([
                'ViisonCommonAnalytics',
                'ViisonCommonCurrencyFormatter',
            ]);
        $this->addSubApplicationExtension('ViisonPickwareERPAnalyticsGrossProfit')
            ->extendingSubApplication('Analytics')
            ->requiringSubApplications([
                'ViisonCommonAnalytics',
                'ViisonCommonCurrencyFormatter',
            ]);
        $this->addSubApplicationExtension('ViisonPickwareERPAnalyticsMainShopCategory')
            ->extendingSubApplication('Analytics')
            ->requiringSubApplication('ViisonCommonCurrencyFormatter');
        $this->addSubApplicationExtension('ViisonPickwareERPAnalyticsNetRevenue')
            ->extendingSubApplication('Analytics')
            ->requiringSubApplication('ViisonCommonCurrencyFormatter');
        $this->addSubApplicationExtension('ViisonPickwareERPAnalyticsSalesRatio')
            ->extendingSubApplication('Analytics')
            ->requiringSubApplications([
                'ViisonCommonAnalytics',
                'ViisonCommonCurrencyFormatter',
            ]);
        $this->addSubApplicationExtension('ViisonPickwareERPAnalyticsStockMovements')
            ->extendingSubApplication('Analytics')
            ->requiringSubApplications([
                'ViisonCommonAnalytics',
            ]);
        $this->addSubApplicationExtension('ViisonPickwareERPAnalyticsStockTurnoverRate')
            ->extendingSubApplication('Analytics')
            ->requiringSubApplication('ViisonCommonAnalytics');
        $this->addSubApplicationExtension('ViisonPickwareERPConfigPurchasePriceModeObserver')
            ->extendingSubApplication('Config')
            ->requiringSubApplication('ViisonPickwareERPPurchasePriceConverter');
        $this->addSubApplicationExtension('ViisonPickwareERPCustomerArticles')
            ->extendingSubApplication('Customer')
            ->requiringSubApplications([
                'ViisonCommonCurrencyFormatter',
                'ViisonCommonPaginationToolbar',
            ]);
        $this->addSubApplicationExtension('ViisonPickwareERPIndexNewsWidget')
            ->extendingSubApplication('Index');
        $this->addSubApplicationExtension('ViisonPickwareERPIndexPurchasePriceModeCheck')
            ->extendingSubApplication('Index')
            ->requiringSubApplication('ViisonPickwareERPPurchasePriceConverter');
        $this->addSubApplicationExtension('ViisonPickwareERPIndexStockCheck')
            ->extendingSubApplication('Index');
        $this->addSubApplicationExtension('ViisonPickwareERPOrderCommon')
            ->extendingSubApplication('Order');
        $this->addSubApplicationExtension('ViisonPickwareERPOrderBatchLabelCreation')
            ->extendingSubApplication('ViisonShippingCommonOrder')
            ->requiringSubApplications([
                'ViisonPickwareERPOrderStatusBasedPositionUpdate',
            ]);
        $this->addSubApplicationExtension('ViisonPickwareERPOrderCancellation')
            ->extendingSubApplication('Order')
            ->requiringSubApplication('ViisonPickwareERPOrderDetailQuantityColumnInjector')
            ->requiringSubApplication('ViisonPickwareERPOrder');
        $this->addSubApplicationExtension('ViisonPickwareERPOrderDeletionWarning')
            ->extendingSubApplication('Order');
        $this->addSubApplicationExtension('ViisonPickwareERPOrderStatusBasedPositionUpdate')
            ->extendingSubApplication('Order')
            ->requiringSubApplications([
                'ViisonPickwareERPWarehouseManagement',
                'ViisonPickwareERPOrderEventBus',
                'ViisonPickwareERPMessageBoxWithCheckboxes',
            ]);
        $this->addSubApplicationExtension('ViisonPickwareERPOrderReturnShipment')
            ->extendingSubApplication('Order')
            ->requiringSubApplication('ViisonPickwareERPReturnShipment')
            ->requiringSubApplication('ViisonPickwareERPCancellation')
            ->requiringSubApplication('ViisonPickwareERPMessageBoxWithCheckboxes');
        $this->addSubApplicationExtension('ViisonPickwareERPOrderShippedColumn')
            ->extendingSubApplication('Order')
            ->requiringSubApplications([
                'ViisonPickwareERPWarehouseManagement',
                'ViisonPickwareERPOrderDetailQuantityColumnInjector',
            ]);
        $this->addSubApplicationExtension('ViisonPickwareERPOrderReturnedColumn')
            ->extendingSubApplication('Order')
            ->requiringSubApplication('ViisonPickwareERPOrderDetailQuantityColumnInjector');
        $this->addSubApplicationExtension('ViisonPickwareERPOrderDerivedQuantityColumns')
            ->extendingSubApplication('Order')
            ->requiringSubApplication('ViisonPickwareERPOrderDetailQuantityColumnInjector');
        $this->addSubApplicationExtension('ViisonPickwareERPOrderStockColumn')
            ->extendingSubApplication('Order');
        $this->addSubApplicationExtension('ViisonPickwareERPOverviewAmountNetColumn')
            ->extendingSubApplication('Overview');
        $this->addSubApplicationExtension('ViisonPickwareERPPluginManagerPickwareModules')
            ->extendingSubApplication('PluginManager');
        $this->addSubApplicationExtension('ViisonPickwareERPSystemInfo')
            ->extendingSubApplication('Systeminfo');
        $this->addSubApplicationExtension('ViisonPickwareERPAnalyticsReturns')
            ->extendingSubApplication('Analytics')
            ->requiringSubApplication('ViisonCommonAnalytics');
        $this->addSubApplicationExtension('ViisonPickwareERPOrderListReturnShipmentStatus')
            ->extendingSubApplication('Order')
            ->requiringSubApplication('ViisonPickwareERPReturnShipment');
        $this->addSubApplicationExtension('ViisonPickwareERPWarehouseManagementBarcodeLabelPrinting')
            ->extendingSubApplication('ViisonPickwareERPWarehouseManagement');

        if ($this->get('pickware.erp.plugin_config_service')->getDisplayAboutPickwareErpWindow()) {
            $this->addSubApplicationExtension('ViisonPickwareERPAboutPopup')
                ->extendingSubApplication('Index')
                ->requiringSubApplication('ViisonCommonIndexPopup');
        }

        // Shopware introduced a delete button for documents in 5.3
        if (!Util::assertMinimumShopwareVersion('5.3')) {
            $this->addSubApplicationExtension('ViisonPickwareERPOrderDocumentDeletion')
                ->extendingSubApplication('Order');
        }

        if (!Util::assertMinimumShopwareVersion('5.5.0')) {
            // Since Shopware 5.5 it has an own order document mailer with different mail templates per document type
            $this->addSubApplicationExtension('ViisonPickwareERPOrderDocumentMailer')
                ->extendingSubApplication('Order')
                ->requiringSubApplication('ViisonCommonMailComposer');
        }

        // "Monkey patch" the order overwrite protection while the following PR is not merged in SW yet:
        // https://github.com/shopware/shopware/pull/1474
        if (!method_exists(Order::class, 'getChanged')) {
            $this->addSubApplicationExtension('ViisonPickwareERPOrderOverwriteProtection')
                ->extendingSubApplication('Order');
        }
    }
}
