<!DOCTYPE html>
<html lang="de">
    <head>
        <meta charset="utf-8">
        <title></title>
    </head>
    <body style="box-sizing: border-box; max-width: 660px; font-family: sans-serif; font-size: 16px; line-height: 1.5; color: #333333; margin: 0 auto 40px; background-color: #ffffff;">
        <header class="pickware-logo" style="margin-bottom: 60px; background-size: contain; background: url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTc2IiBoZWlnaHQ9IjExMCIgdmlld0JveD0iMCAwIDE3NiAxMTAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHRpdGxlPkxvZ288L3RpdGxlPjxnIGZpbGw9Im5vbmUiIGZpbGwtcnVsZT0iZXZlbm9kZCI+PHBhdGggZmlsbD0iIzFGQjNGQiIgZD0iTTAgMGgxNzZ2MTEwSDB6Ii8+PGcgZmlsbD0iI0ZGRiI+PHBhdGggZD0iTTMwLjAxNiA3OS41NTNjMCAyLjQxOC0uNzMzIDQuMjY3LTIuMiA1LjU0OC0xLjQ2NiAxLjI4Mi0zLjU1IDEuOTIyLTYuMjU1IDEuOTIySDE5LjU4djcuOTloLTQuNjIyVjcyLjU0Nmg2Ljk2M2MyLjY0MyAwIDQuNjU0LjU4NyA2LjAzIDEuNzYgMS4zNzggMS4xNzMgMi4wNjYgMi45MjMgMi4wNjYgNS4yNDh6bS0xMC40MzggMy41NjVoMS41MmMxLjQyMyAwIDIuNDg2LS4yOSAzLjE5Mi0uODY4LjcwNi0uNTggMS4wNi0xLjQyMiAxLjA2LTIuNTI4IDAtMS4xMTYtLjI5Ny0xLjk0LS44ODgtMi40NzQtLjU5Mi0uNTMzLTEuNTItLjgtMi43OC0uOGgtMi4xMDR2Ni42N3pNMzMuMzY4IDcyLjU0NWg0LjYyMnYyMi40NjhoLTQuNjIyVjcyLjU0NXpNNTEuOTc0IDc2LjE4OGMtMS43NCAwLTMuMDg3LjY3My00LjA0IDIuMDItLjk1NiAxLjM0OC0xLjQzMiAzLjIyNS0xLjQzMiA1LjYzMyAwIDUuMDEgMS44MjQgNy41MTUgNS40NzIgNy41MTUgMS41MyAwIDMuMzg0LS4zOTQgNS41Ni0xLjE4M3YzLjk5NmMtMS43ODguNzY4LTMuNzg2IDEuMTUyLTUuOTkyIDEuMTUyLTMuMTcyIDAtNS41OTctLjk5LTcuMjc3LTIuOTczLTEuNjgtMS45ODMtMi41Mi00LjgyOC0yLjUyLTguNTM3IDAtMi4zMzYuNDEzLTQuMzgyIDEuMjM4LTYuMTQuODI1LTEuNzU2IDIuMDEtMy4xMDQgMy41NTYtNC4wNCAxLjU0NC0uOTQgMy4zNTYtMS40MDcgNS40MzQtMS40MDcgMi4xMTcgMCA0LjI0NC41MjcgNi4zODIgMS41ODJsLTEuNDkgMy44NzNjLS44MTctLjQtMS42MzctLjc0OC0yLjQ2Mi0xLjA0NS0uODI1LS4yOTctMS42MzUtLjQ0NS0yLjQzLS40NDVNNzguOTQ0IDk1LjAxM2gtNS4yNWwtNS43MS05LjQ2Ni0xLjk1MyAxLjQ0NHY4LjAyM2gtNC42MlY3Mi41NDVoNC42MnYxMC4yODJsMS44Mi0yLjY0NCA1LjkwNS03LjYzOGg1LjEzbC03LjYwNSA5Ljk0MyA3LjY2NCAxMi41MjUiLz48cGF0aCBkPSJNMTAyLjE1NyA5NS4wMTNoLTUuMjYzTDkzLjk0IDgzLjIxYy0uMTA4LS40Mi0uMjk1LTEuMjg3LS41NTgtMi42MDQtLjI2My0xLjMxNy0uNDE0LTIuMi0uNDU1LTIuNjUtLjA2LjU1Mi0uMjA4IDEuNDQtLjQ0NyAyLjY2NS0uMjM4IDEuMjI2LS40MjMgMi4xLS41NSAyLjYybC0yLjk0IDExLjc3M2gtNS4yNDdMNzguMTggNzIuNTQ1aDQuNTVsMi43ODcgMTIuMjY0Yy40ODYgMi4yNjMuODQgNC4yMjUgMS4wNiA1Ljg4NS4wNTgtLjU4NC4xOTUtMS40ODguNDA4LTIuNzEzLjIxNS0xLjIyNC40MTYtMi4xNzQuNjA1LTIuODVsMy4xNzYtMTIuNTg3aDQuMzY4TDk4LjMxIDg1LjEzYy4xNC41NjUuMzE0IDEuNDI2LjUyMiAyLjU4My4yMSAxLjE1OC4zNjggMi4xNTIuNDc3IDIuOTgyLjA5OC0uOC4yNTgtMS43OTYuNDc3LTIuOTkuMjE4LTEuMTkzLjQxNy0yLjE1OC41OTYtMi44OTZsMi43NzMtMTIuMjY1aDQuNTQ4bC01LjU0NyAyMi40NjhNMTIyLjE4NSA5NS4wMTNsLTEuNTgtNS4zNDhoLTcuOTQ3bC0xLjU4IDUuMzQ4aC00Ljk4Mmw3LjY5NC0yMi41Nmg1LjY1bDcuNzI2IDIyLjU2aC00Ljk4em0tMi42ODMtOS4zNDRjLTEuNDYyLTQuODQ3LTIuMjg0LTcuNTg3LTIuNDY4LTguMjIyLS4xODUtLjYzNS0uMzE2LTEuMTM4LS4zOTYtMS41MDYtLjMyNyAxLjMxLTEuMjY3IDQuNTU0LTIuODE4IDkuNzI3aDUuNjgyek0xMzMuNzY4IDg2LjM5MnY4LjYyaC00LjYyMlY3Mi41NDZoNi4zNTJjMi45NjIgMCA1LjE1NC41NTYgNi41NzYgMS42NjggMS40MiAxLjExMiAyLjEzMiAyLjggMi4xMzIgNS4wNjMgMCAxLjMyMi0uMzUzIDIuNDk4LTEuMDYgMy41MjctLjcwNSAxLjAzLTEuNzA0IDEuODM3LTIuOTk2IDIuNDIgMy4yOCA1LjA1MiA1LjQxOCA4LjMxNSA2LjQxIDkuNzloLTUuMTI4bC01LjIwNC04LjYyaC0yLjQ2em0wLTMuODczaDEuNDljMS40NjMgMCAyLjU0LS4yNTIgMy4yMzctLjc1NC42OTUtLjUwMiAxLjA0My0xLjI5IDEuMDQzLTIuMzY3IDAtMS4wNjYtLjM1NS0xLjgyNC0xLjA2NS0yLjI3NS0uNzEtLjQ1LTEuODEyLS42NzYtMy4zMDMtLjY3NmgtMS40MDJ2Ni4wN3pNMTYxLjA5NyA5NS4wMTNoLTEyLjU1NVY3Mi41NDVoMTIuNTU1djMuOTA0aC03LjkzM3Y0LjkzMmg3LjM4djMuOTAzaC03LjM4djUuNzk0aDcuOTMzdjMuOTMzIi8+PC9nPjwvZz48L3N2Zz4=) no-repeat center top; padding: 90px 50px 50px;"></header>
        <p>
            Mit Pickware verfügen Sie nun über eine Warenwirtschaft direkt in Shopware! Alle Funktionen sind direkt
            in das Shopware Backend integriert, so dass keine externe Infrastruktur mit eigener Datenhaltung und
            fehleranfälligen Synchronisationsprozessen notwendig ist. Pickware arbeitet jederzeit direkt auf
            den Echtzeitdaten Ihres Shops.
        </p>
        <p class="tipp" style="background: #E8F6FD url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMzUiIGhlaWdodD0iMzUiIHZpZXdCb3g9IjAgMCAzNSAzNSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48dGl0bGU+aW5mby0zLWljb248L3RpdGxlPjxwYXRoIGQ9Ik0xNy41IDBDNy44MzUgMCAwIDcuODM1IDAgMTcuNVM3LjgzNSAzNSAxNy41IDM1IDM1IDI3LjE2NSAzNSAxNy41IDI3LjE2NSAwIDE3LjUgMHptMy4zMTUgMjcuODg1aC01LjQ0VjE2Ljk5aC0zLjA1MnYtMi4xMjhoOC40OTJ2MTMuMDIzem0tMi43Mi0xNS41NzdjLTEuNjIyIDAtMi45MzctMS4zMTUtMi45MzctMi45MzYgMC0xLjYyMiAxLjMxNS0yLjkzNiAyLjkzNy0yLjkzNiAxLjYyIDAgMi45MzYgMS4zMTQgMi45MzYgMi45MzYgMCAxLjYyLTEuMzE0IDIuOTM2LTIuOTM1IDIuOTM2eiIgZmlsbD0iI0E3RERGNyIgZmlsbC1ydWxlPSJldmVub2RkIi8+PC9zdmc+) no-repeat 25px 31px; margin: 25px 0; padding: 30px 30px 30px 80px; border-color: #d1edfb; border-style: solid; border-width: 1px 1px 1px 10px;">
            <strong>Sie möchten Ihre Prozesse im Lager und Versand noch weiter optimieren und automatisieren? Sie
            betreiben ein Ladengeschäft und möchten es mit Ihrem Online Shop verbinden?  Dann empfehlen wir
            Ihnen Shopware WMS bzw. Shopware POS powered by Pickware!</strong> Selbstverständlich können Sie alle Funktionen
            30 Tage lang kostenlos testen. Laden Sie sich hierfür einfach das entsprechende Plugin und unsere
            Pickware Apps herunter und verbinden Sie sie mit ihrem Shop.
        </p>
        <p class="pickware-link" style="margin-bottom: 20px; margin-top: 30px; text-align: center; padding: 20px 50px; border: 1px solid #999999;" align="center">
            Alle Informationen zu Pickware und unseren weiteren Module finden Sie auf
            <span class="button-panel" style="display: block; margin-top: 20px; margin-bottom: 10px; text-align: center;">
                <a href="http://www.pickware.de" target="_blank" style="color: white; display: inline-block; margin-top: 5px; border-radius: 5px; font-size: 120%; font-weight: bold; text-decoration: none; background: #273a4f; padding: 8px 20px;">www.pickware.de →</a>
            </span>
        </p>
        <h2 style="padding-bottom: 10px; border-bottom-color: #333333; border-bottom-width: 1px; border-bottom-style: solid; margin: 60px 0 40px;">Dokumentation</h2>
        <p>
            Unsere Dokumentation zur Einrichtung und Nutzung von Pickware finden Sie unter
            <a href="http://www.pickware.de/dokumentation" target="_blank" style="color: #19a6eb;">www.pickware.de/dokumentation</a>.
        </p>
        <h2 style="padding-bottom: 10px; border-bottom-color: #333333; border-bottom-width: 1px; border-bottom-style: solid; margin: 60px 0 40px;">Pickware Anwendungsbeispiele</h2>
        <h3>Einkauf</h3>
        <p class="feature" style="margin-bottom: 30px; padding-left: 30px; color: #555555;">
            Klicken Sie in der Shopware Menüleiste auf Artikel&nbsp;→&nbsp;Einkauf. Im Menü
            <strong style="color: #333333;">Lieferanten</strong> können Sie Lieferanten anlegen und Artikel zu Lieferanten zuordnen.
            Im Menü <strong style="color: #333333;">Bestellwesen</strong> sehen Sie eine Übersicht aller offenen
            Lieferantenbestellungen und können neue Lieferantenbestellungen erstellen. Artikel, deren Bestand unter
            dem definierten Mindestlagerbestand ist, werden dabei automatisch zur Nachbestellung vorgeschlagen und sind
            mit einem entsprechenden Warnhinweis versehen. Wählen Sie die Artikel, die Sie nachbestellen möchten aus
            und ziehen Sie sie in das rechte Fenster oder übernehmen sie einfach alle Vorschläge auf einmal. Durch
            einen Klick auf <strong style="color: #333333;">Alle Bestellungen erzeugen</strong> können Sie die
            Lieferantenbestellungen anschließend erstellen und sehen sie in der Bestellübersicht.
        </p>
        <h3>Einzelne Bestellpositionen stornieren</h3>
        <p class="feature" style="margin-bottom: 30px; padding-left: 30px; color: #555555;">
            Klicken Sie in den Bestelldetails einer Bestellung auf das Tab <strong style="color: #333333;">Positionen</strong>.
            Wählen Sie die Position aus, die Sie stornieren möchten und klicken Sie oben auf
            <strong style="color: #333333;">Positionen stornieren</strong>. Nach einem weiteren Klick auf
            <strong style="color: #333333;">Bestätigen</strong> werden die Positionen storniert und die Stornorechnung für den
            Versand an den Kunden erstellt.
        </p>
        <h3>Warenbestand bewerten</h3>
        <p class="feature" style="margin-bottom: 30px; padding-left: 30px; color: #555555;">
            Unter Artikel&nbsp;→&nbsp;Lager→&nbsp;Bewerteter Warenbestand können Sie sich den Wert Ihres Warenbestands zu jeder
            Zeit steuerlich korrekt nach dem LIFO-Prinzip anzeigen lassen und anschließend als CSV exportieren.
            Voraussetzung hierfür ist die einmalige korrekte Erfassung des Warenbestands. Dies ist am einfachsten
            mit der Nutzung von Shopware WMS und unseren mobilen Barcode-Scannern möglich.
        </p>
        <p class="pickware-mobile-remark" style="margin-top: 50px; padding-left: 25px; border-left-width: 5px; border-left-color: #DDDDDD; border-left-style: solid;">
            <strong>Weitere Anwendungsbeispiele finden Sie in unserer Dokumentation unter
                <a href="http://www.pickware.de/dokumentation" target="_blank" style="color: #19a6eb;">www.pickware.de/dokumentation</a></strong>
        </p>
        <footer style="margin-top: 100px; margin-bottom: 80px;">
            <div style="margin: 50px 0 10px;">
                <div>
                    <table style="margin-top: 0px; margin-bottom: 20px; width: 100%;">
                        <tbody>
                            <tr>
                                <td valign="top" style="width:110px">
                                    <img src="data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPHN2ZyB3aWR0aD0iMTgwcHgiIGhlaWdodD0iMTIxcHgiIHZpZXdCb3g9IjAgMCAxODAgMTIxIiB2ZXJzaW9uPSIxLjEiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiPgogICAgPCEtLSBHZW5lcmF0b3I6IFNrZXRjaCA1MS4zICg1NzU0NCkgLSBodHRwOi8vd3d3LmJvaGVtaWFuY29kaW5nLmNvbS9za2V0Y2ggLS0+CiAgICA8dGl0bGU+Y29udmVydGVkRmlsZTwvdGl0bGU+CiAgICA8ZGVzYz5DcmVhdGVkIHdpdGggU2tldGNoLjwvZGVzYz4KICAgIDxkZWZzPjwvZGVmcz4KICAgIDxnIGlkPSJQYWdlLTEiIHN0cm9rZT0ibm9uZSIgc3Ryb2tlLXdpZHRoPSIxIiBmaWxsPSJub25lIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPgogICAgICAgIDxnIGlkPSJjb252ZXJ0ZWRGaWxlIiBmaWxsLXJ1bGU9Im5vbnplcm8iPgogICAgICAgICAgICA8cG9seWdvbiBpZD0iU2hhcGUiIGZpbGw9IiMxOUE2RUIiIHBvaW50cz0iMCAxMjAuMjE4IDE4MCAxMjAuMjE4IDE4MCAwLjIxOCAwIDAuMjE4Ij48L3BvbHlnb24+CiAgICAgICAgICAgIDxwYXRoIGQ9Ik0yMS43NjUsODYuOTQ1IEwyMy4yNzcsODYuOTQ1IEMyNC42OSw4Ni45NDUgMjUuNzQ5LDg2LjY2NyAyNi40NSw4Ni4xMDggQzI3LjE1Miw4NS41NSAyNy41MDMsODQuNzM2IDI3LjUwMyw4My42NjkgQzI3LjUwMyw4Mi41OTIgMjcuMjA5LDgxLjc5NiAyNi42MjEsODEuMjgyIEMyNi4wMzMsODAuNzY4IDI1LjExMSw4MC41MTEgMjMuODU1LDgwLjUxMSBMMjEuNzY1LDgwLjUxMSBMMjEuNzY1LDg2Ljk0NSBaIE0zMi4xNDQsODMuNTA1IEMzMi4xNDQsODUuODM5IDMxLjQxNSw4Ny42MjIgMjkuOTU3LDg4Ljg1OCBDMjguNSw5MC4wOTQgMjYuNDI2LDkwLjcxMSAyMy43MzcsOTAuNzExIEwyMS43NjUsOTAuNzExIEwyMS43NjUsOTguNDIxIEwxNy4xNjgsOTguNDIxIEwxNy4xNjgsNzYuNzQ1IEwyNC4wOTMsNzYuNzQ1IEMyNi43MjMsNzYuNzQ1IDI4LjcyMSw3Ny4zMTIgMzAuMDksNzguNDQzIEMzMS40Niw3OS41NzQgMzIuMTQ0LDgxLjI2MyAzMi4xNDQsODMuNTA2IEwzMi4xNDQsODMuNTA1IFogTTM1LjQ3OCw3Ni43NDUgTDQwLjA3NCw3Ni43NDUgTDQwLjA3NCw5OC40MTkgTDM1LjQ3OCw5OC40MTkgTDM1LjQ3OCw3Ni43NDUgWiBNNTMuOTgsODAuMjYgQzUyLjI1LDgwLjI2IDUwLjkxLDgwLjkxIDQ5Ljk2MSw4Mi4yMDggQzQ5LjAxMSw4My41MDggNDguNTM4LDg1LjMyIDQ4LjUzOCw4Ny42NDIgQzQ4LjUzOCw5Mi40NzYgNTAuMzUyLDk0Ljg5MiA1My45NzksOTQuODkyIEM1NS41MDIsOTQuODkyIDU3LjM0NSw5NC41MTIgNTkuNTEsOTMuNzUgTDU5LjUxLDk3LjYwNSBDNTcuNzMsOTguMzQ3IDU1Ljc0NCw5OC43MTcgNTMuNTUsOTguNzE3IEM1MC4zOTYsOTguNzE3IDQ3Ljk4NCw5Ny43NiA0Ni4zMTMsOTUuODQ3IEM0NC42NDMsOTMuOTM3IDQzLjgwNyw5MS4xOTEgNDMuODA3LDg3LjYxMyBDNDMuODA3LDg1LjM1OSA0NC4yMTcsODMuMzg1IDQ1LjAzOSw4MS42OSBDNDUuODU5LDc5Ljk5NCA0Ny4wMzcsNzguNjk1IDQ4LjU3NCw3Ny43OSBDNTAuMTEyLDc2Ljg4NiA1MS45MTQsNzYuNDM0IDUzLjk3OSw3Ni40MzQgQzU2LjA4NSw3Ni40MzQgNTguMjAxLDc2Ljk0NCA2MC4zMjUsNzcuOTYxIEw1OC44NDMsODEuNjk2IEM1OC4wNDYwNDUxLDgxLjMxNjU1MTkgNTcuMjI5MTkwMyw4MC45ODAzOTYzIDU2LjM5Niw4MC42ODkgQzU1LjYyMDM3NCw4MC40MTAyODk2IDU0LjgwMzE2MDMsODAuMjY0OTAyIDUzLjk3OSw4MC4yNTkgTDUzLjk4LDgwLjI2IFogTTgwLjc5OSw5OC40MiBMNzUuNTgsOTguNDIgTDY5LjkwMSw4OS4yODggTDY3Ljk1OCw5MC42ODEgTDY3Ljk1OCw5OC40MjEgTDYzLjM2Miw5OC40MjEgTDYzLjM2Miw3Ni43NDUgTDY3Ljk1OCw3Ni43NDUgTDY3Ljk1OCw4Ni42NjMgTDY5Ljc2Nyw4NC4xMTMgTDc1LjY0LDc2Ljc0NSBMODAuNzQsNzYuNzQ1IEw3My4xNzgsODYuMzM3IEw4MC43OTgsOTguNDE5IEw4MC43OTksOTguNDIgWiIgaWQ9IlNoYXBlIiBmaWxsPSIjRkZGRkZGIj48L3BhdGg+CiAgICAgICAgICAgIDxwYXRoIGQ9Ik0xMDMuODgyLDk4LjQyIEw5OC42NDgsOTguNDIgTDk1LjcxMyw4Ny4wMzUgQzk1LjYwMyw4Ni42MjkgOTUuNDE5LDg1Ljc5MiA5NS4xNTYsODQuNTIyIEM5NC44OTQsODMuMjUyIDk0Ljc0NCw4Mi4zOTkgOTQuNzA0LDgxLjk2NCBDOTQuNjQ1LDgyLjQ5NyA5NC40OTcsODMuMzU1IDk0LjI2LDg0LjUzNyBDOTQuMDk1ODk1Niw4NS4zODMzMjc4IDkzLjkxMjg0OTcsODYuMjI1ODcyNSA5My43MTEsODcuMDY0IEw5MC43OTEsOTguNDIgTDg1LjU3MSw5OC40MiBMODAuMDQsNzYuNzQ2IEw4NC41NjMsNzYuNzQ2IEw4Ny4zMzUsODguNTc2IEM4Ny44MTksOTAuNzYxIDg4LjE3LDkyLjY1MyA4OC4zODgsOTQuMjU0IEM4OC40NDcsOTMuNjkxIDg4LjU4Miw5Mi44MTkgODguNzk1LDkxLjYzOCBDODkuMDA4LDkwLjQ1NyA4OS4yMDksODkuNTM5IDg5LjM5Niw4OC44ODggTDkyLjU1NCw3Ni43NDYgTDk2Ljg5OSw3Ni43NDYgTDEwMC4wNTcsODguODg4IEMxMDAuMTk1LDg5LjQzMiAxMDAuMzY5LDkwLjI2MiAxMDAuNTc3LDkxLjM3OCBDMTAwLjc4Myw5Mi40OTUgMTAwLjk0MSw5My40NTMgMTAxLjA1LDk0LjI1NCBDMTAxLjE1LDkzLjQ4NCAxMDEuMzA3LDkyLjUyMiAxMDEuNTI2LDkxLjM3MSBDMTAxLjY5NzMwMSw5MC40MzQwMDkgMTAxLjg5NDcxMSw4OS41MDE5Nzk3IDEwMi4xMTgsODguNTc2IEwxMDQuODc2LDc2Ljc0NiBMMTA5LjM5OSw3Ni43NDYgTDEwMy44ODIsOTguNDIgWiBNMTIxLjEzLDg5LjQwNiBDMTIwLjMwNDIwNSw4Ni43NjQ3NTE1IDExOS40ODYyMDIsODQuMTIxMDczNCAxMTguNjc2LDgxLjQ3NSBDMTE4LjUyODEyMiw4MC45OTUzOTA0IDExOC4zOTcwNDIsODAuNTEwNzYxNiAxMTguMjgzLDgwLjAyMiBDMTE3Ljk1Nyw4MS4yODcgMTE3LjAyMyw4NC40MTUgMTE1LjQ4LDg5LjQwNiBMMTIxLjEzLDg5LjQwNiBaIE0xMjMuNzk4LDk4LjQyIEwxMjIuMjI2LDkzLjI2IEwxMTQuMzI0LDkzLjI2IEwxMTIuNzUyLDk4LjQyIEwxMDcuOCw5OC40MiBMMTE1LjQ1LDc2LjY1NiBMMTIxLjA3LDc2LjY1NiBMMTI4Ljc1LDk4LjQyIEwxMjMuNzk4LDk4LjQyIFogTTEzNS4zMTcsODYuMzY3IEwxMzYuOCw4Ni4zNjcgQzEzOC4yNTIsODYuMzY3IDEzOS4zMjUsODYuMTI1IDE0MC4wMTcsODUuNjQxIEMxNDAuNzA5LDg1LjE1NyAxNDEuMDU1LDg0LjM5NSAxNDEuMDU1LDgzLjM1NyBDMTQxLjA1NSw4Mi4zMyAxNDAuNzAxLDgxLjU5OSAxMzkuOTk1LDgxLjE2MyBDMTM5LjI4OCw4MC43MjggMTM4LjE5NCw4MC41MTEgMTM2LjcxMSw4MC41MTEgTDEzNS4zMTcsODAuNTExIEwxMzUuMzE3LDg2LjM2NyBaIE0xMzUuMzE3LDkwLjEwMyBMMTM1LjMxNyw5OC40MiBMMTMwLjcyLDk4LjQyIEwxMzAuNzIsNzYuNzQ1IEwxMzcuMDM3LDc2Ljc0NSBDMTM5Ljk4Myw3Ni43NDUgMTQyLjE2Miw3Ny4yODIgMTQzLjU3Nyw3OC4zNTUgQzE0NC45OSw3OS40MjcgMTQ1LjY5Niw4MS4wNTUgMTQ1LjY5Niw4My4yMzkgQzE0NS42OTYsODQuNTE0IDE0NS4zNDUsODUuNjQ5IDE0NC42NDQsODYuNjQxIEMxNDMuOTQxLDg3LjYzNSAxNDIuOTQ4LDg4LjQxMyAxNDEuNjY0LDg4Ljk3NyBDMTQ0LjkyNSw5My44NDkgMTQ3LjA1MSw5Ni45OTcgMTQ4LjAzOCw5OC40MiBMMTQyLjkzOCw5OC40MiBMMTM3Ljc2Myw5MC4xMDMgTDEzNS4zMTcsOTAuMTAzIFogTTE2Mi40OTIsOTguNDIgTDE1MC4wMDgsOTguNDIgTDE1MC4wMDgsNzYuNzQ2IEwxNjIuNDkyLDc2Ljc0NiBMMTYyLjQ5Miw4MC41MTEgTDE1NC42MDQsODAuNTExIEwxNTQuNjA0LDg1LjI2OSBMMTYxLjk0NCw4NS4yNjkgTDE2MS45NDQsODkuMDM2IEwxNTQuNjA0LDg5LjAzNiBMMTU0LjYwNCw5NC42MjQgTDE2Mi40OTIsOTQuNjI0IEwxNjIuNDkyLDk4LjQyIFoiIGlkPSJTaGFwZSIgZmlsbD0iI0ZGRkZGRiI+PC9wYXRoPgogICAgICAgIDwvZz4KICAgIDwvZz4KPC9zdmc+" alt="Pickware Logo" style="display: inline-block; margin-right: 0px; margin-top: 15px; width: 100px;">
                                </td>
                                <td style="width: 130px; line-height: 1.5; font-size: 16px; vertical-align: middle; border-left-width: 0; border-left-color: #BBBBBB; border-left-style: solid; padding: 0 0 0 5px;" valign="middle">
                                    <strong>Pickware GmbH</strong>
                                    <br>Goebelstr. 21
                                    <br>64293 Darmstadt</td>
                                <td style="width: 200px; line-height: 1.5; font-size: 16px; vertical-align: middle; border-left-width: 0; border-left-color: #BBBBBB; border-left-style: solid; padding: 0 0 0 20px;" valign="middle">+49 6151 629 30 30
                                    <br><a href="mailto:info@pickware.de" style="color: #1fb3fb; text-decoration: none;">info@pickware.de</a>
                                    <br><a href="https://www.pickware.de" rel="nofollow" target="_blank" style="color: #1fb3fb; text-decoration: none;">www.pickware.de</a>
                                </td>
                                <td style="width: 60px; vertical-align: middle; text-align: right; padding: 10px 0 0;" align="right" valign="middle"><img style="width:60px" src="data:image/png;base64,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"
                                    alt="Pickware ist Shopware Technology Partner"></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </footer>
    </body>
</html>
