// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPAboutContact.controller.Main', {

    extend: 'Ext.app.Controller',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_about/contact',
    viisonConfigNamespace: 'ViisonPickwareERPAboutContact',

    init: function () {
        this.control({
            'viison_common_mail_composer-window viison_common_mail_composer-main': {
                sendMail: this.onSendMail,
            },
        });

        // Create the initial email content
        var mailContent = (
            '\n\n--\n'
            + this.getViisonSnippet('mail/body/headline') + '\n'
            + this.getViisonSnippet('mail/body/shop_url') + '\t\t' + this.getViisonConfig('shopURL') + '\n'
            + this.getViisonSnippet('mail/body/shopware_version') + '\t' + this.getViisonConfig('shopwareVersion') + '\n'
            + this.getViisonSnippet('mail/body/pickware_plugin_version') + '\t' + this.getViisonConfig('pickwarePluginVersion')
        );

        // Create and show email window
        this.mainWindow = Ext.create('Shopware.apps.ViisonCommonMailComposer.view.Window', {
            subApp: this.subApplication,
            hideAttachmentField: true,
            mail: {
                toAddress: 'info@pickware.de',
                subject: this.getViisonSnippet('mail/subject'),
                content: mailContent,
            },
        });
        this.mainWindow.setTitle(this.getViisonSnippet('window/title'));
        this.mainWindow.el.addCls('viison_pickware_erp_about_contact');

        this.phonePanel = Ext.create('Ext.container.Container', {
            cls: 'is--phone-info',
            html: (
                '<span>' + this.getViisonSnippet('phone/msg') + '</span>'
                + '<span class="is--phone-number">' + this.getViisonSnippet('phone/nr') + '</span>'
            ),
        });
        this.mainWindow.dataPanel.add(this.phonePanel);
        this.mainWindow.show();
    },

    /**
     * Checks the given form for validity and, if valid, sends a new contact mail
     * using the form data.
     *
     * @param Shopware.apps.ViisonCommonMailComposer.view.Main mailForm
     */
    onSendMail: function (mailForm) {
        if (!mailForm.getForm().isValid()) {
            return;
        }

        // Send the email using the email form data
        var params = mailForm.getValues();
        var mailWindow = mailForm.up('viison_common_mail_composer-window');
        mailWindow.setLoading(true);
        Ext.Ajax.request({
            url: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPAboutContact/sendEmail'),
            params: params,
            scope: this,
            success: function (response) {
                mailWindow.setLoading(false);
                var json = Ext.JSON.decode(response.responseText, true);
                if (json.success) {
                    Shopware.Notification.createGrowlMessage(
                        this.getViisonSnippet('notification/success/title'),
                        this.getViisonSnippet('notification/success/message'),
                        'ViisonPickwareERPAboutContact'
                    );
                    mailWindow.close();
                } else {
                    Shopware.Notification.createGrowlMessage(
                        this.getViisonSnippet('notification/error/title'),
                        this.getViisonSnippet('notification/error/message'),
                        'ViisonPickwareERPAboutContact'
                    );
                }
            },
        });
    },

});
