// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPAboutPopup.controller.Main', {

    override: 'Shopware.apps.Index.controller.Main',

    /**
     * Override the init method to start our ViisonCommonIndexPopup application
     * as soon as the Shopware backend is opened.
     */
    init: function () {
        this.callParent(arguments);
        Shopware.app.Application.addSubApplication({
            name: 'Shopware.apps.ViisonCommonIndexPopup',
            localizedName: 'Pickware',
            params: {
                windowWidth: 740,
                contentURL: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPAboutBackend/getContent'),
                saveURL: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPAboutPopup/save'),
            },
        });
    },

});
