// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPAnalyticsArticle.controller.Main', {

    override: 'Shopware.apps.Analytics.controller.Main',

    constructor: function () {
        var ret = this.callParent(arguments);

        this.addViisonCommonAnalysis('Shopware.apps.ViisonPickwareERPAnalyticsArticle', {
            moduleHandler: Ext.create('Shopware.apps.ViisonCommonAnalytics.controller.ModuleWithImprovedToolbar', {
                nextModuleHandler: Ext.create('Shopware.apps.ViisonCommonAnalytics.controller.ModuleWithFilter', {
                    filterModules: {
                        selectedCustomerGroups: {
                            factoryClass: 'Shopware.apps.ViisonCommonAnalytics.controller.FilterModule.CustomerGroupsFactory',
                            factoryConfig: {
                                store: Ext.create('Shopware.store.CustomerGroup'),
                            },
                        },
                        selectedShops: {
                            factoryClass: 'Shopware.apps.ViisonCommonAnalytics.controller.FilterModule.DefaultShopFactory',
                        },
                        fromDate: {
                            factoryClass: 'Shopware.apps.ViisonCommonAnalytics.controller.FilterModule.DefaultFromDateFactory',
                        },
                        toDate: {
                            factoryClass: 'Shopware.apps.ViisonCommonAnalytics.controller.FilterModule.DefaultToDateFactory',
                        },
                        selectedCategory: {
                            factoryClass: 'Shopware.apps.ViisonCommonAnalytics.controller.FilterModule.ArticleCategoryFactory',
                            factoryConfig: {
                                store: Ext.create('Shopware.apps.ViisonPickwareERPAnalyticsArticle.store.navigation.Category'),
                            },
                        },
                    },
                }),
            }),
        });

        return ret;
    },

});
