// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPAnalyticsArticle.store.navigation.Article', {

    extend: 'Ext.data.Store',

    alias: 'widget.analytics-store-navigation-article',

    remoteSort: true,

    fields: [
        'name',
        'amount',
        'amountNet',
        'count',
        'articleNumber',
        'price',
        'supplier',
        'instock',
    ],

    sorters: {
        property: 'amount',
        direction: 'DESC',
    },

    proxy: {
        type: 'ajax',
        url: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPAnalyticsArticle/getArticleSales'),
        reader: {
            type: 'json',
            root: 'data',
        },
    },

    constructor: function (config) {
        config.fields = this.fields;

        if (config.shopStore) {
            config.shopStore.each(function (shop) {
                config.fields[config.fields.length] = 'amount' + shop.data.id;
                config.fields[config.fields.length] = 'amountNet' + shop.data.id;
            });
        }

        this.callParent([config]);
    },
});
