// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * A custom table implementation for the 'article' analytics.
 */
Ext.define('Shopware.apps.ViisonPickwareERPAnalyticsArticle.view.table.Article', {

    /**
     * Extend from the Shopware analytics table.
     */
    extend: 'Shopware.apps.Analytics.view.main.Table',

    /**
     * The short alias for this class.
     */
    alias: 'widget.analytics-table-article',

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_analytics/article',

    /**
     * The default initializer configuring the table columns which creates all table columns.
     */
    initComponent: function () {
        this.columns = [{
            xtype: 'gridcolumn',
            dataIndex: 'name',
            text: this.getViisonSnippet('table/article'),
            flex: 2,
        }, {
            xtype: 'gridcolumn',
            dataIndex: 'supplier',
            text: this.getViisonSnippet('table/supplier'),
            flex: 1,
        }, {
            xtype: 'gridcolumn',
            dataIndex: 'articleNumber',
            text: this.getViisonSnippet('table/article_number'),
            align: 'right',
            width: 100,
        }, {
            xtype: 'numbercolumn',
            dataIndex: 'price',
            text: this.getViisonSnippet('table/price'),
            renderer: ViisonCurrencyFormatter.renderer,
            align: 'right',
            width: 75,
        }, {
            xtype: 'gridcolumn',
            dataIndex: 'instock',
            text: this.getViisonSnippet('table/in_stock'),
            align: 'right',
            width: 75,
        }, {
            xtype: 'gridcolumn',
            dataIndex: 'count',
            text: this.getViisonSnippet('table/sales'),
            align: 'right',
            width: 75,
        }, {
            xtype: 'numbercolumn',
            dataIndex: 'amount',
            text: this.getViisonSnippet('table/volume'),
            renderer: ViisonCurrencyFormatter.renderer,
            align: 'right',
            width: 85,
        }, {
            xtype: 'numbercolumn',
            dataIndex: 'amountNet',
            text: this.getViisonSnippet('table/volume_net'),
            renderer: ViisonCurrencyFormatter.renderer,
            align: 'right',
            width: 85,
        }];

        this.callParent(arguments);
    },

});
