// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPAnalyticsGrossProfit.store.navigation.GrossProfit', {

    extend: 'Ext.data.Store',
    alias: 'widget.analytics-store-navigation-gross-profit',
    remoteSort: true,
    fields: [
        { name: 'articleId', type: 'int' },
        { name: 'article_number', type: 'string' },
        { name: 'name', type: 'string' },
        { name: 'sales_quantity', type: 'int' },
        { name: 'sales_ratio', type: 'float' },
        { name: 'sales_value', type: 'float' },
        { name: 'sales_value_net', type: 'float' },
        { name: 'purchase_value', type: 'float' },
        { name: 'purchase_value_net', type: 'float' },
        { name: 'gross_profit', type: 'float' },
        { name: 'gross_profit_percentage', type: 'float' },
    ],
    sorters: [
        {
            property: 'gross_profit_percentage',
            direction: 'DESC',
        },
        {
            property: 'gross_profit',
            direction: 'DESC',
        },
    ],
    proxy: {
        type: 'ajax',
        url: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPAnalyticsGrossProfit/getGrossProfit'),
        reader: {
            type: 'json',
            root: 'data',
            totalProperty: 'total',
        },
    },

});
