// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPAnalyticsGrossProfit.view.table.GrossProfit', {

    extend: 'Shopware.apps.Analytics.view.main.Table',
    alias: 'widget.analytics-table-gross-profit',
    mixins: [
        'Shopware.apps.ViisonCommonAnalytics.view.main.TableHelpers',
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_analytics/gross_profit',

    features: [
        { ftype: 'summary' },
    ],

    initComponent: function () {
        this.columns = {
            items: this.getColumns(),
            defaults: {
                flex: 1,
                sortable: true,
            },
        };

        this.callParent(arguments);
    },

    getColumns: function () {
        function makeSummaryTypeFunction(forDataIndex) {
            return function () {
                return this.store.getProxy().getReader().rawData.summary[forDataIndex];
            };
        }

        return [
            {
                dataIndex: 'article_number',
                text: this.getViisonSnippet('table/article_number'),
            },
            {
                dataIndex: 'name',
                text: this.getViisonSnippet('table/article_name'),
            },
            {
                xtype: 'gridcolumn',
                dataIndex: 'sales_quantity',
                text: this.getViisonSnippet('table/sales_quantity'),
                align: 'right',
            },
            {
                dataIndex: 'gross_profit',
                text: this.getViisonSnippet('table/gross_profit'),
                align: 'right',
                renderer: ViisonCurrencyFormatter.renderer,
                summaryType: makeSummaryTypeFunction('gross_profit').bind(this),
                summaryRenderer: ViisonCurrencyFormatter.renderer,
                tooltip: this.getViisonSnippet('tooltip/gross_profit_column'),
            },
            {
                xtype: 'numbercolumn',
                dataIndex: 'gross_profit_percentage',
                text: this.getViisonSnippet('table/gross_profit_percentage'),
                align: 'right',
                renderer: this.percentageRenderer,
                summaryType: makeSummaryTypeFunction('gross_profit_percentage').bind(this),
                summaryRenderer: this.percentageRenderer,
                tooltip: this.getViisonSnippet('tooltip/gross_profit_percentage_column'),
            },
            {
                dataIndex: 'sales_value_net',
                text: this.getViisonSnippet('table/sales_net'),
                align: 'right',
                renderer: ViisonCurrencyFormatter.renderer,
                summaryType: makeSummaryTypeFunction('sales_value_net').bind(this),
                summaryRenderer: ViisonCurrencyFormatter.renderer,
                tooltip: this.getViisonSnippet('tooltip/sales_net_column'),
            },
            {
                dataIndex: 'sales_value',
                text: this.getViisonSnippet('table/sales'),
                align: 'right',
                renderer: ViisonCurrencyFormatter.renderer,
                summaryType: makeSummaryTypeFunction('sales_value').bind(this),
                summaryRenderer: ViisonCurrencyFormatter.renderer,
                tooltip: this.getViisonSnippet('tooltip/sales_column'),
            },
            {
                dataIndex: 'purchase_value_net',
                text: this.getViisonSnippet('table/purchase_value_net'),
                align: 'right',
                renderer: ViisonCurrencyFormatter.renderer,
                summaryType: makeSummaryTypeFunction('purchase_value_net').bind(this),
                summaryRenderer: ViisonCurrencyFormatter.renderer,
                tooltip: this.getViisonSnippet('tooltip/purchase_net_column'),
            },
            {
                dataIndex: 'purchase_value',
                text: this.getViisonSnippet('table/purchase_value'),
                align: 'right',
                renderer: ViisonCurrencyFormatter.renderer,
                summaryType: makeSummaryTypeFunction('purchase_value').bind(this),
                summaryRenderer: ViisonCurrencyFormatter.renderer,
                tooltip: this.getViisonSnippet('tooltip/purchase_column'),
            },
            {
                xtype: 'actioncolumn',
                align: 'right',
                items: [
                    {
                        iconCls: 'sprite-inbox',
                        tooltip: this.getViisonSnippet('table/open_article'),
                        handler: function (view, rowIndex) {
                            Shopware.app.Application.addSubApplication({
                                name: 'Shopware.apps.Article',
                                action: 'detail',
                                params: {
                                    articleId: view.getStore().getAt(rowIndex).get('articleId'),
                                },
                            });
                        },
                    },
                ],
            },
        ];
    },

});
