// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * By overriding the default navigation store, the 'mainshop categories' element is added
 * to the 'sales by' sub tree.
 */
Ext.define('Shopware.apps.ViisonPickwareERPAnalyticsMainShopCategory.store.Navigation', {

    /**
     * Override the default analytics navigation store or at least parts of it.
     */
    override: 'Shopware.apps.Analytics.store.Navigation',

    statics: {
        viisonPickwareERPAnalyticsMainShopCategoryInitialized: false,
    },

    /**
     * Adds a new report to the tree view.
     *
     * @param config The configuration used for constructing this instance.
     */
    constructor: function (config) {
        // TODO: The following may be entirely unnecessary, and the other analytics modules work fine without it:
        // Add list item only once, since the root property is a member of the parent's class prototype
        if (!this.statics().viisonPickwareERPAnalyticsMainShopCategoryInitialized) {
            // Find 'sales by' navigation group
            this.root.children.push({
                text: ViisonCommonApp.getSnippet('nav/salesBy/mainShopCategory', 'backend/viison_pickware_erp_analytics/main_shop_category'),
                id: 'main-shop-category',
                iconCls: 'sprite-currency-euro',
                store: 'analytics-store-navigation-main-shop-categories',
                leaf: true,
            });

            this.statics().viisonPickwareERPAnalyticsMainShopCategoryInitialized = true;
        }

        this.callParent([config]);
    },

});
