// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPAnalyticsMainShopCategory.store.navigation.MainShopCategories', {

    extend: 'Ext.data.Store',
    alias: 'widget.analytics-store-navigation-main-shop-categories',
    remoteSort: true,
    fields: [
        { name: 'orderCount', type: 'int' },
        { name: 'name', type: 'string' },
        { name: 'node', type: 'int' },
        { name: 'turnover', type: 'float' },
        { name: 'turnoverNet', type: 'float' },
    ],
    proxy: {
        type: 'ajax',
        url: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPAnalyticsMainShopCategory/getMainShopCategories'),
        reader: {
            type: 'json',
            root: 'data',
            totalProperty: 'total',
        },
    },

});
