// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPAnalyticsMainShopCategory.view.table.MainShopCategory', {

    extend: 'Shopware.apps.Analytics.view.main.Table',
    alias: 'widget.analytics-table-main-shop-category',
    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_analytics/main_shop_category',

    initComponent: function () {
        this.columns = {
            items: this.getColumns(),
            defaults: {
                flex: 1,
                sortable: false,
            },
        };

        this.callParent(arguments);
    },

    getColumns: function () {
        return [
            {
                dataIndex: 'name',
                text: this.getViisonSnippet('table/category'),
            },
            {
                xtype: 'numbercolumn',
                dataIndex: 'turnover',
                text: this.getViisonSnippet('table/turnover'),
                renderer: ViisonCurrencyFormatter.renderer,
            },
            {
                xtype: 'numbercolumn',
                dataIndex: 'turnoverNet',
                text: this.getViisonSnippet('table/turnoverNet'),
                renderer: ViisonCurrencyFormatter.renderer,
            },
        ];
    },

});
