// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPAnalyticsNetRevenue.store.navigation.CustomerGroups', {

    override: 'Shopware.apps.Analytics.store.navigation.CustomerGroups',

    constructor: function (config) {
        this.fields.push('turnoverNet');
        config.fields = this.fields;

        if (config.shopStore) {
            config.shopStore.each(function (shop) {
                config.fields.push('turnover' + shop.data.id);
                config.fields.push('turnoverNet' + shop.data.id);
                config.fields.push('orderCount' + shop.data.id);
            });
        }

        // Skip overridden method and directly call its parent method
        //
        // eslint-disable-next-line no-restricted-properties, no-caller
        this.superclass[arguments.callee.$name].apply(this, arguments);
    },

});
