// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPAnalyticsNetRevenue.view.table.CustomerGroup', {

    override: 'Shopware.apps.Analytics.view.table.CustomerGroup',

    initComponent: function () {
        this.columns = {
            items: this.getColumns(),
            defaults: {
                flex: 1,
                sortable: false,
            },
        };

        this.initShopColumns([
            {
                text: ViisonCommonApp.getSnippet('general/turnover', 'backend/viison_pickware_erp_analytics/net_revenue') + ': [0]',
                dataIndex: 'turnover',
                renderer: this.currencyRenderer,
            },
            {
                text: ViisonCommonApp.getSnippet('general/turnoverNet', 'backend/viison_pickware_erp_analytics/net_revenue') + ': [0]',
                dataIndex: 'turnoverNet',
                renderer: this.currencyRenderer,
            },
            {
                text: ViisonCommonApp.getSnippet('general/count', 'backend/viison_pickware_erp_analytics/net_revenue') + ': [0]',
                dataIndex: 'orderCount',
            },
        ]);

        // Skip overridden method and directly call its parent method
        // This is necessary because calling the overridden method would change the columns back to the original ones.
        // We also can't call the overridden method earlier, because the layout is created from the columns attribute
        // at the time the parent constructor is called. ExtJS 4.1.3 and later have this.callSuper(arguments) for this,
        // but Shopware uses 4.1.1 so we need this workaround. http://stackoverflow.com/questions/15898565/overriding-extjs-classes-and-invoking-callparent
        //
        // eslint-disable-next-line no-restricted-properties, no-caller
        this.superclass.superclass[arguments.callee.$name].apply(this, arguments);
    },

    getColumns: function () {
        var columns = this.callParent(arguments);

        // Insert net turnover column
        columns.splice(2, 0, {
            xtype: 'numbercolumn',
            dataIndex: 'turnoverNet',
            text: ViisonCommonApp.getSnippet('general/turnoverNet', 'backend/viison_pickware_erp_analytics/net_revenue'),
            renderer: this.currencyRenderer,
        });

        return columns;
    },

});
