// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPAnalyticsNetRevenue.view.table.Supplier', {

    override: 'Shopware.apps.Analytics.view.table.Supplier',

    /**
     * Creates the grid columns
     *
     * @return [array] grid columns
     */
    getColumns: function () {
        var columns = this.callParent(arguments);

        // Insert net turnover column
        columns.push({
            dataIndex: 'turnoverNet',
            text: ViisonCommonApp.getSnippet('general/turnoverNet', 'backend/viison_pickware_erp_analytics/net_revenue'),
            renderer: this.currencyRenderer,
        });

        return columns;
    },

});
