// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPAnalyticsReturns.view.table.Returns', {

    extend: 'Shopware.apps.Analytics.view.main.Table',
    alias: 'widget.analytics-table-returns',
    mixins: [
        'Shopware.apps.ViisonCommonAnalytics.view.main.TableHelpers',
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    features: [
        { ftype: 'summary' },
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_analytics/returns',

    initComponent: function () {
        this.columns = {
            items: this.getColumns(),
            defaults: {
                flex: 1,
                sortable: true,
            },
        };

        this.callParent(arguments);
    },

    /**
     * @Overwrite
     *
     * Overwrite percentageRenderer from ViisonCommonAnalytics.view.main.TableHelpers to ensure the correct version
     * is used. Currently we have a problem with the Analytics View Loading: the newest version is not always loaded.
     * Improve this, and remove the duplicated code in the future!
     *
     * @param value
     * @returns {*}
     */
    percentageRenderer: function (value) {
        // NULL-percentage clause
        if (value === null) {
            return '-';
        }
        // Regular behavior (original code)
        if (typeof value === 'string') {
            value = parseFloat(value);
        }
        if (Number.isNaN(value) || typeof value !== 'number') {
            return '-';
        }

        // Use Ext.util.Format.number formatting to get localized percentage decimal separator (,/.)
        return Ext.util.Format.number((Math.round(value * 100 * 100) / 100).toFixed(2), '0.00') + '\u202F%';
    },

    getColumns: function () {
        function makeSummaryTypeFunction(forDataIndex) {
            return function () {
                return this.store.getProxy().getReader().rawData.summary[forDataIndex];
            };
        }

        return [
            {
                dataIndex: 'articleName',
                text: this.getViisonSnippet('table/article_name'),
                align: 'left',
            },
            {
                dataIndex: 'articleNumber',
                text: this.getViisonSnippet('table/article_number'),
                align: 'right',
            },
            {
                dataIndex: 'shipped',
                text: this.getViisonSnippet('table/shipped'),
                tooltip: this.getViisonSnippet('tooltip/shipped'),
                align: 'right',
                summaryType: makeSummaryTypeFunction('shipped').bind(this),
            },
            {
                dataIndex: 'returned',
                text: this.getViisonSnippet('table/returned'),
                tooltip: this.getViisonSnippet('tooltip/returned'),
                align: 'right',
                summaryType: makeSummaryTypeFunction('returned').bind(this),
            },
            {
                dataIndex: 'stocked',
                hidden: true,
                text: this.getViisonSnippet('table/stocked'),
                tooltip: this.getViisonSnippet('tooltip/stocked'),
                align: 'right',
                summaryType: makeSummaryTypeFunction('stocked').bind(this),
            },
            {
                dataIndex: 'writtenOff',
                hidden: true,
                text: this.getViisonSnippet('table/written_off'),
                tooltip: this.getViisonSnippet('tooltip/written_off'),
                align: 'right',
                summaryType: makeSummaryTypeFunction('writtenOff').bind(this),
            },
            {
                dataIndex: 'stockedRatio',
                text: this.getViisonSnippet('table/stocked_ratio'),
                tooltip: this.getViisonSnippet('tooltip/stocked_ratio'),
                align: 'right',
                renderer: this.percentageRenderer,
                summaryType: makeSummaryTypeFunction('stockedRatio').bind(this),
                summaryRenderer: this.percentageRenderer,
            },
            {
                dataIndex: 'writtenOffRatio',
                text: this.getViisonSnippet('table/written_off_ratio'),
                tooltip: this.getViisonSnippet('tooltip/written_off_ratio'),
                align: 'right',
                renderer: this.percentageRenderer,
                summaryType: makeSummaryTypeFunction('writtenOffRatio').bind(this),
                summaryRenderer: this.percentageRenderer,
            },
            {
                dataIndex: 'returnedRatio',
                text: this.getViisonSnippet('table/returned_ratio'),
                tooltip: this.getViisonSnippet('tooltip/returned_ratio'),
                align: 'right',
                renderer: this.percentageRenderer,
                summaryType: makeSummaryTypeFunction('returnedRatio').bind(this),
                summaryRenderer: this.percentageRenderer,
            },
            {
                xtype: 'actioncolumn',
                align: 'right',
                items: [
                    {
                        iconCls: 'sprite-inbox',
                        tooltip: this.getViisonSnippet('tooltip/open_article'),
                        handler: function (view, rowIndex) {
                            Shopware.app.Application.addSubApplication({
                                name: 'Shopware.apps.Article',
                                action: 'detail',
                                params: {
                                    articleId: view.getStore().getAt(rowIndex).get('articleId'),
                                },
                            });
                        },
                    },
                ],
            },
        ];
    },

});
