// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPAnalyticsSalesRatio.controller.Main', {

    override: 'Shopware.apps.Analytics.controller.Main',

    constructor: function () {
        var ret = this.callParent(arguments);

        this.addViisonCommonAnalysis('Shopware.apps.ViisonPickwareERPAnalyticsSalesRatio', {
            moduleHandler: Ext.create('Shopware.apps.ViisonCommonAnalytics.controller.ModuleWithImprovedToolbar', {
                nextModuleHandler: Ext.create('Shopware.apps.ViisonCommonAnalytics.controller.ModuleWithFilter', {
                    filterModules: {
                        selectedCustomerGroups: {
                            factoryClass: 'Shopware.apps.ViisonCommonAnalytics.controller.FilterModule.CustomerGroupsFactory',
                            factoryConfig: {
                                store: Ext.create('Shopware.store.CustomerGroup'),
                            },
                        },
                        selectedShops: {
                            factoryClass: 'Shopware.apps.ViisonCommonAnalytics.controller.FilterModule.DefaultShopFactory',
                        },
                        fromDate: {
                            factoryClass: 'Shopware.apps.ViisonCommonAnalytics.controller.FilterModule.DefaultFromDateFactory',
                        },
                        toDate: {
                            factoryClass: 'Shopware.apps.ViisonCommonAnalytics.controller.FilterModule.DefaultToDateFactory',
                        },
                    },
                }),
            }),
        });

        return ret;
    },

});
