// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

/**
 * By overriding the default navigation store, the 'sales ratio' element is added.
 */
Ext.define('Shopware.apps.ViisonPickwareERPAnalyticsSalesRatio.store.Navigation', {

    /**
     * Override the default analytics navigation store or at least parts of it.
     */
    override: 'Shopware.apps.Analytics.store.Navigation',

    /**
     * Adds a new report to the tree view.
     *
     * @param config The configuration used for constructing this instance.
     */
    constructor: function (config) {
        this.root.children.push({
            text: ViisonCommonApp.getSnippet('nav/salesRatio', 'backend/viison_pickware_erp_analytics/sales_ratio'),
            id: 'sales-ratio',
            iconCls: 'sprite-edit-percent',
            store: 'analytics-store-navigation-sales-ratio',
            multiShop: true, // To have the default selectedShops widget (for languageId queries).
            leaf: true,
            viisonCommonAnalysisId: 'Shopware.apps.ViisonPickwareERPAnalyticsSalesRatio',
        });

        this.callParent([config]);
    },

});
