// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPAnalyticsSalesRatio.store.navigation.SalesRatio', {

    extend: 'Ext.data.Store',
    alias: 'widget.analytics-store-navigation-sales-ratio',
    remoteSort: true,
    fields: [
        { name: 'article_number', type: 'string' },
        { name: 'name', type: 'string' },
        { name: 'sales', type: 'int' },
        { name: 'stocked', type: 'int' },
        { name: 'sales_ratio', type: 'float' },
    ],
    sorters: {
        property: 'sales_ratio',
        direction: 'DESC',
    },
    proxy: {
        type: 'ajax',
        url: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPAnalyticsSalesRatio/getSalesRatio'),
        reader: {
            type: 'json',
            root: 'data',
            totalProperty: 'total',
        },
    },

});
