// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPAnalyticsSalesRatio.view.table.SalesRatio', {

    extend: 'Shopware.apps.Analytics.view.main.Table',
    alias: 'widget.analytics-table-sales-ratio',

    mixins: [
        'Shopware.apps.ViisonCommonAnalytics.view.main.TableHelpers',
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_analytics/sales_ratio',

    initComponent: function () {
        this.columns = {
            items: this.getColumns(),
            defaults: {
                flex: 1,
                sortable: true,
            },
        };

        this.callParent(arguments);
    },

    getColumns: function () {
        return [
            {
                dataIndex: 'article_number',
                text: this.getViisonSnippet('table/article_number'),
                sortable: false,
            },
            {
                dataIndex: 'name',
                text: this.getViisonSnippet('table/article_name'),
            },
            {
                xtype: 'numbercolumn',
                dataIndex: 'sales',
                text: this.getViisonSnippet('table/sells'),
                format: '0',
                align: 'right',
            },
            {
                xtype: 'numbercolumn',
                dataIndex: 'stocked',
                text: this.getViisonSnippet('table/stock'),
                format: '0',
                align: 'right',
            },
            {
                xtype: 'numbercolumn',
                dataIndex: 'sales_ratio',
                align: 'right',
                text: this.getViisonSnippet('table/sales_ratio'),
                renderer: this.percentageRenderer,
            },
        ];
    },

});
