// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPAnalyticsStockMovements.controller.FilterModule.WarehouseFactory', {

    mixins: [
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_analytics/stock_movements',

    constructor: function (config) {
        if (!config.store) {
            throw new Error('Needs a store');
        }
        this.config = Object.create(null, {
            store: {
                value: config.store,
                enumerable: true,
            },
        });

        this.callParent(arguments);
    },

    getToolbarComponentValueRetriever: function () {
        return function (toolbar) {
            var selectedWarehouses = toolbar.child('[name=viison_common_analytics_warehouse_selection]').getValue();
            if (selectedWarehouses === undefined || selectedWarehouses === null) {
                return selectedWarehouses;
            }

            return selectedWarehouses.join(',');
        };
    },

    getToolbarFilterConfig: function () {
        return {
            componentConfig: Ext.apply(
                {
                    xtype: 'combobox',
                    iconCls: 'sprite-gear',
                    name: 'viison_common_analytics_warehouse_selection',
                    queryMode: 'remote',
                    fieldLabel: this.getViisonSnippet('toolbar/warehouse'),
                    store: this.warehouseStore,
                    multiSelect: true,
                    displayField: 'name',
                    valueField: 'id',
                },
                this.config
            ),
        };
    },

});
