// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPAnalyticsStockMovements.store.Navigation', {

    override: 'Shopware.apps.Analytics.store.Navigation',

    /**
     * Adds a new report to the tree view.
     *
     * @param config The configuration used for constructing this instance.
     */
    constructor: function (config) {
        this.root.children.push({
            text: ViisonCommonApp.getSnippet('navigation/stockMovements', 'backend/viison_pickware_erp_analytics/stock_movements'),
            id: 'stock-movements',
            iconCls: 'sprite-arrow-branch-090',
            store: 'analytics-store-navigation-stock-movements',
            leaf: true,
            viisonCommonAnalysisId: 'Shopware.apps.ViisonPickwareERPAnalyticsStockMovements',
        });

        this.callParent([config]);
    },

});
