// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPAnalyticsStockMovements.store.navigation.StockMovements', {

    extend: 'Ext.data.Store',
    alias: 'widget.analytics-store-navigation-stock-movements',
    remoteSort: true,
    fields: [
        { name: 'articleNumber', type: 'string' },
        { name: 'articleName', type: 'string' },
        { name: 'sumPositiveChanges', type: 'int' },
        { name: 'sumNegativeChanges', type: 'int' },
        { name: 'sumIncoming', type: 'int' },
        { name: 'sumOutgoing', type: 'int' },
        { name: 'sumPurchase', type: 'int' },
        { name: 'sumSale', type: 'int' },
        { name: 'sumReturn', type: 'int' },
        { name: 'sumStocktake', type: 'int' },
        { name: 'sumManual', type: 'int' },
        { name: 'sumRelocation', type: 'int' },
        { name: 'sumInitialization', type: 'int' },
    ],
    proxy: {
        type: 'ajax',
        url: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPAnalyticsStockMovements/getStockMovements'),
        reader: {
            type: 'json',
            root: 'data',
            totalProperty: 'total',
        },
    },

});
