// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPAnalyticsStockMovements.view.table.StockMovements', {

    extend: 'Shopware.apps.Analytics.view.main.Table',
    alias: 'widget.analytics-table-stock-movements',

    mixins: [
        'Shopware.apps.ViisonCommonAnalytics.view.main.TableHelpers',
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_analytics/stock_movements',

    initComponent: function () {
        this.columns = {
            items: this.getColumns(),
            defaults: {
                flex: 1,
                sortable: true,
            },
        };

        this.callParent(arguments);
    },

    getColumns: function () {
        return [
            {
                dataIndex: 'articleNumber',
                text: this.getViisonSnippet('column/articleNumber'),
                flex: 1,
            },
            {
                dataIndex: 'articleName',
                text: this.getViisonSnippet('column/articleName'),
                flex: 3,
            },
            {
                dataIndex: 'sumPositiveChanges',
                text: this.getViisonSnippet('column/sumPositiveChanges'),
                align: 'right',
                flex: 2,
            },
            {
                dataIndex: 'sumNegativeChanges',
                text: this.getViisonSnippet('column/sumNegativeChanges'),
                align: 'right',
                flex: 2,
            },
            {
                dataIndex: 'sumPurchase',
                text: this.getViisonSnippet('column/sumPurchase'),
                align: 'right',
                flex: 1,
                renderer: function (value, meta) {
                    meta.tdCls = 'is--viison-left-separating-column';

                    return value;
                },
            },
            {
                dataIndex: 'sumSale',
                text: this.getViisonSnippet('column/sumSale'),
                align: 'right',
                flex: 1,
            },
            {
                dataIndex: 'sumReturn',
                text: this.getViisonSnippet('column/sumReturn'),
                align: 'right',
                flex: 1,
            },
            {
                dataIndex: 'sumIncoming',
                text: this.getViisonSnippet('column/sumIncoming'),
                align: 'right',
                flex: 1,
            },
            {
                dataIndex: 'sumOutgoing',
                text: this.getViisonSnippet('column/sumOutgoing'),
                align: 'right',
                flex: 1,
            },
            {
                dataIndex: 'sumManual',
                text: this.getViisonSnippet('column/sumManual'),
                align: 'right',
                flex: 1,
            },
            {
                dataIndex: 'sumRelocation',
                text: this.getViisonSnippet('column/sumRelocation'),
                align: 'right',
                flex: 1,
            },
            {
                dataIndex: 'sumStocktake',
                text: this.getViisonSnippet('column/sumStocktake'),
                align: 'right',
                flex: 1,
            },
            {
                dataIndex: 'sumInitialization',
                text: this.getViisonSnippet('column/sumInitialization'),
                align: 'right',
                flex: 1,
            },
        ];
    },

});
