// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPAnalyticsStockTurnoverRate.store.Navigation', {

    override: 'Shopware.apps.Analytics.store.Navigation',

    constructor: function (config) {
        this.root.children.push({
            text: ViisonCommonApp.getSnippet('nav/title', 'backend/viison_pickware_erp_analytics/stock_turnover_rate'),
            id: 'viison-pickware-erp-analytics--stock-turnover-rate',
            iconCls: 'sprite-wooden-box--arrow',
            store: 'analytics-store-navigation--viison-pickware-erp-analytics--stock-turnover-rate',
            multiShop: false, // To have the default selectedShops widget (for languageId queries).
            leaf: true,
            viisonCommonAnalysisId: 'Shopware.apps.ViisonPickwareERPAnalyticsStockTurnoverRate',
        });

        this.callParent([config]);
    },

});
