// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPAnalyticsStockTurnoverRate.store.navigation.Report', {

    extend: 'Ext.data.Store',
    alias: 'widget.analytics-store-navigation--viison-pickware-erp-analytics--stock-turnover-rate',
    remoteSort: true,
    fields: [
        { name: 'articleOrderNumber', type: 'string' },
        { name: 'articleName', type: 'string' },
        { name: 'soldQuantity', type: 'string' },
        { name: 'averageStock', type: 'string' },
        { name: 'stockTurnoverRate', type: 'string' },
        { name: 'averageStoragePeriod', type: 'string' },
    ],
    sorters: {
        property: 'stockTurnoverRate',
        direction: 'DESC',
    },
    proxy: {
        type: 'ajax',
        url: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPAnalyticsStockTurnoverRate/getStockTurnoverRate'),
        reader: {
            type: 'json',
            root: 'data',
            totalProperty: 'total',
        },
    },

});
