// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPAnalyticsStockTurnoverRate.view.table.Report', {
    extend: 'Shopware.apps.Analytics.view.main.Table',
    alias: 'widget.analytics-table-viison-pickware-erp-analytics--stock-turnover-rate',

    mixins: [
        'Shopware.apps.ViisonCommonAnalytics.view.main.TableHelpers',
        'Shopware.apps.ViisonCommonApp.Mixin',
    ],
    viisonSnippetNamespace: 'backend/viison_pickware_erp_analytics/stock_turnover_rate',

    initComponent: function () {
        this.columns = {
            items: this.getColumns(),
            defaults: {
                flex: 2,
                sortable: true,
            },
        };

        this.callParent(arguments);
    },

    /**
     * Returns a numberrenderer with the given precision and "," as decimal separator.
     * @param precision
     * @returns Function
     */
    getNumberFormatter: function (precision) {
        var decimals = '';
        for (var i = 0; i < precision; i += 1) {
            decimals += '0';
        }

        return function (value) {
            return Ext.util.Format.number(value, '0.' + decimals);
        };
    },

    getColumns: function () {
        return [
            {
                dataIndex: 'articleOrderNumber',
                header: this.getViisonSnippet('table/articleOrderNumber'),
            },
            {
                dataIndex: 'articleName',
                header: this.getViisonSnippet('table/article_name'),
            },
            {
                dataIndex: 'soldQuantity',
                header: this.getViisonSnippet('table/soldQuantity'),
                align: 'right',
            },
            {
                dataIndex: 'averageStock',
                header: this.getViisonSnippet('table/averageStock'),
                align: 'right',
                renderer: this.getNumberFormatter(2),
            },
            {
                dataIndex: 'stockTurnoverRate',
                header: this.getViisonSnippet('table/stockTurnoverRate'),
                align: 'right',
                renderer: this.getNumberFormatter(2),
            },
            {
                dataIndex: 'averageStoragePeriod',
                header: this.getViisonSnippet('table/averageStoragePeriod'),
                align: 'right',
                renderer: this.getNumberFormatter(1),
            },
        ];
    },

});
