// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPApiLog.controller.Main', {

    extend: 'Ext.app.Controller',

    /**
     * @Override
     */
    init: function () {
        this.control({
            'viison_pickware_erp_api_log-list': {
                truncateLog: this.onTruncateLog,
                searchFieldChanged: this.onSearchFieldChanged,
                showDetail: this.onShowDetail,
            },
        });

        var logStore = Ext.create('Shopware.apps.ViisonPickwareERPApiLog.store.Log', {});
        logStore.load();

        this.mainWindow = this.getView('Main').create({
            store: logStore,
        }).show();

        this.callParent(arguments);
    },

    /**
     * Sends a request to the backend to truncate the API log and, if successful,
     * updates the view to display the new log size.
     *
     * @param {Shopware.apps.ViisonPickwareERPApiLog.view.List} list
     */
    onTruncateLog: function (list) {
        var mainWindow = list.up('viison_pickware_erp_api_log-main');
        mainWindow.setLoading(true);
        Ext.Ajax.request({
            method: 'POST',
            url: ViisonCommonApp.assembleBackendUrl('ViisonPickwareERPApiLog/truncateLog'),
            callback: function (options, success, response) {
                mainWindow.setLoading(false);
                // Update the displayed log size
                var responseData = Ext.JSON.decode(response.responseText, true);
                if (responseData && responseData.success) {
                    list.logSizeField.update(responseData);
                }
                list.store.loadPage(1);
            },
        });
    },

    /**
     * Sets the given query as an extra parameter to the lists store's proxy
     * and reloads the store.
     *
     * @param {Shopware.apps.ViisonPickwareERPApiLog.view.List} list
     * @param {string} query
     */
    onSearchFieldChanged: function (list, query) {
        list.store.getProxy().extraParams.query = query;
        list.store.loadPage(1);
    },

    /**
     * Opens a new detail window for the given log record.
     *
     * @param {Shopware.apps.ViisonPickwareERPApiLog.view.List} list
     * @param {Shopware.apps.ViisonPickwareERPApiLog.model.Log} logRecord
     */
    onShowDetail: function (list, logRecord) {
        this.getView('Detail').create({
            record: logRecord,
        }).show();
    },

});
