// Copyright (c) Pickware GmbH. All rights reserved.
// This file is part of software that is released under a proprietary license.
// You must not copy, modify, distribute, make publicly available, or execute
// its contents or parts thereof without express permission by the copyright
// holder, unless otherwise permitted by law.

Ext.define('Shopware.apps.ViisonPickwareERPApiLog.model.Log', {

    extend: 'Ext.data.Model',
    fields: [
        { name: 'id', type: 'int' },
        { name: 'date', type: 'date' },
        { name: 'method', type: 'string' },
        { name: 'url', type: 'string' },
        { name: 'requestHeaders', type: 'string' },
        { name: 'requestData', type: 'string' },
        { name: 'responseCode', type: 'int' },
        { name: 'responseHeaders', type: 'string' },
        { name: 'responseData', type: 'string' },
        { name: 'exception', type: 'string' },
        { name: 'user', type: 'string' },
        { name: 'ipAddress', type: 'string' },
        { name: 'userAgent', type: 'string' },
        {
            name: 'computationTime',
            type: 'string',
            convert: function (value) {
                return (value) ? Ext.util.Format.number(value, '0.000') : '';
            },
        },
        { name: 'curlCommand', type: 'string' },
    ],

});
